﻿---
title: Tracing fields
description: Distributed tracing makes it possible to analyze performance throughout a microservice architecture all in one view. This is accomplished by tracing all...
url: https://www.elastic.co/docs/reference/ecs/ecs-tracing
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Tracing fields
Distributed tracing makes it possible to analyze performance throughout a microservice architecture all in one view. This is accomplished by tracing all of the requests - from the initial web request in the front-end service - to queries made through multiple back-end services.
Unlike most field sets in ECS, the tracing fields are *not* nested under the field set name. In other words, the correct field name is `trace.id`, not `tracing.trace.id`, and so on.

## Tracing field details


| Field                                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Level    |
|-----------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [span.id](#field-span-id)               | Unique identifier of the span within the scope of its trace.A span represents an operation within a transaction, such as a request to another service, or a database query.type: keywordexample: `3ff9a8981b7ccd5a`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [span_id](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+span_id+%22&type=code)                       | extended |
| [trace.id](#field-trace-id)             | Unique identifier of the trace.A trace groups multiple events like transactions that belong together. For example, a user request handled by multiple inter-connected services.type: keywordexample: `4bf92f3577b34da6a3ce929d0e0e4736`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [trace_id](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+trace_id+%22&type=code) | extended |
| [transaction.id](#field-transaction-id) | Unique identifier of the transaction within the scope of its trace.A transaction is the highest level of work measured within a service, such as a request to a server.type: keywordexample: `00f067aa0ba902b7`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) Not applicable.                                                                                                             | extended |