﻿---
title: TLS fields
description: Fields related to a TLS connection. These fields focus on the TLS protocol itself and intentionally avoids in-depth analysis of the related x.509 certificate...
url: https://www.elastic.co/docs/reference/ecs/ecs-tls
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# TLS fields
Fields related to a TLS connection. These fields focus on the TLS protocol itself and intentionally avoids in-depth analysis of the related x.509 certificate files.

## TLS field details


| Field                                                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Level    |
|---------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [tls.cipher](#field-tls-cipher)                                     | String indicating the cipher used during the current connection.type: keywordexample: `TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.cipher](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-cipher)                                                                                                                                                                                                                                                                  | extended |
| [tls.client.certificate](#field-tls-client-certificate)             | PEM-encoded stand-alone certificate offered by the client. This is usually mutually-exclusive of `client.certificate_chain` since this value also exists in that list.type: keywordexample: `MII...`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.certificate](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-certificate)                                                                                                                                                                   | extended |
| [tls.client.certificate_chain](#field-tls-client-certificate-chain) | Array of PEM-encoded certificates that make up the certificate chain offered by the client. This is usually mutually-exclusive of `client.certificate` since that value should be the first certificate in the chain.type: keywordNote: This field should contain an array of values.example: `["MII...", "MII..."]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.certificate_chain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-certificate-chain)                                       | extended |
| [tls.client.hash.md5](#field-tls-client-hash-md5)                   | Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.type: keywordexample: `0F76C7F2C55BFD7D8E8B8F4BFBF0C9EC`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.hash.md5](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-hash-md5)                                                                                                               | extended |
| [tls.client.hash.sha1](#field-tls-client-hash-sha1)                 | Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.type: keywordexample: `9E393D93138888D288266C2D915214D1D1CCEB2A`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.hash.sha1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-hash-sha1)                                                                                                    | extended |
| [tls.client.hash.sha256](#field-tls-client-hash-sha256)             | Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.type: keywordexample: `0687F666A054EF17A08E2F2162EAB4CBC0D265E1D7875BE74BF3C712CA92DAF0`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.hash.sha256](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-hash-sha256)                                                                      | extended |
| [tls.client.issuer](#field-tls-client-issuer)                       | Distinguished name of subject of the issuer of the x.509 certificate presented by the client.type: keywordexample: `CN=Example Root CA, OU=Infrastructure Team, DC=example, DC=com`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.issuer](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-issuer)                                                                                                                                                                                              | extended |
| [tls.client.ja3](#field-tls-client-ja3)                             | A hash that identifies clients based on how they perform an SSL/TLS handshake.type: keywordexample: `d4e5b18d6b55c71272893221c96ba240`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.ja3](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-ja3)                                                                                                                                                                                                                                                 | extended |
| [tls.client.not_after](#field-tls-client-not-after)                 | Date/Time indicating when client certificate is no longer considered valid.type: dateexample: `2021-01-01T00:00:00.000Z`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.not_after](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-not-after)                                                                                                                                                                                                                                                   | extended |
| [tls.client.not_before](#field-tls-client-not-before)               | Date/Time indicating when client certificate is first considered valid.type: dateexample: `1970-01-01T00:00:00.000Z`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.not_before](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-not-before)                                                                                                                                                                                                                                                     | extended |
| [tls.client.server_name](#field-tls-client-server-name)             | Also called an SNI, this tells the server which hostname to which the client is attempting to connect to. When this value is available, it should get copied to `destination.domain`.type: keywordexample: `www.elastic.co`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [tls.client.subject](#field-tls-client-subject)                     | Distinguished name of subject of the x.509 certificate presented by the client.type: keywordexample: `CN=myclient, OU=Documentation Team, DC=example, DC=com`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.subject](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-subject)                                                                                                                                                                                                                  | extended |
| [tls.client.supported_ciphers](#field-tls-client-supported-ciphers) | Array of ciphers offered by the client during the client hello.type: keywordNote: This field should contain an array of values.example: `["TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "..."]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.client.supported_ciphers](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-supported-ciphers)                                                                                                                      | extended |
| [tls.curve](#field-tls-curve)                                       | String indicating the curve used for the given cipher, when applicable.type: keywordexample: `secp256r1`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.curve](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-curve)                                                                                                                                                                                                                                                                                         | extended |
| [tls.established](#field-tls-established)                           | Boolean flag indicating if the TLS negotiation was successful and transitioned to an encrypted tunnel.type: boolean![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.established](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-established)                                                                                                                                                                                                                                                                  | extended |
| [tls.next_protocol](#field-tls-next-protocol)                       | String indicating the protocol being tunneled. Per the values in the IANA registry ([https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids](https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids)), this string should be lower case.type: keywordexample: `http/1.1`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.next_protocol](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-next-protocol) | extended |
| [tls.resumed](#field-tls-resumed)                                   | Boolean flag indicating if this TLS connection was resumed from an existing TLS negotiation.type: boolean![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.resumed](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-resumed)                                                                                                                                                                                                                                                                                    | extended |
| [tls.server.certificate](#field-tls-server-certificate)             | PEM-encoded stand-alone certificate offered by the server. This is usually mutually-exclusive of `server.certificate_chain` since this value also exists in that list.type: keywordexample: `MII...`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.server.certificate](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-certificate)                                                                                                                                                                   | extended |
| [tls.server.certificate_chain](#field-tls-server-certificate-chain) | Array of PEM-encoded certificates that make up the certificate chain offered by the server. This is usually mutually-exclusive of `server.certificate` since that value should be the first certificate in the chain.type: keywordNote: This field should contain an array of values.example: `["MII...", "MII..."]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.server.certificate_chain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-certificate-chain)                                       | extended |
| [tls.server.hash.md5](#field-tls-server-hash-md5)                   | Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.type: keywordexample: `0F76C7F2C55BFD7D8E8B8F4BFBF0C9EC`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.server.hash.md5](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-hash-md5)                                                                                                               | extended |
| [tls.server.hash.sha1](#field-tls-server-hash-sha1)                 | Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.type: keywordexample: `9E393D93138888D288266C2D915214D1D1CCEB2A`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.server.hash.sha1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-hash-sha1)                                                                                                    | extended |
| [tls.server.hash.sha256](#field-tls-server-hash-sha256)             | Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.type: keywordexample: `0687F666A054EF17A08E2F2162EAB4CBC0D265E1D7875BE74BF3C712CA92DAF0`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.server.hash.sha256](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-hash-sha256)                                                                      | extended |
| [tls.server.issuer](#field-tls-server-issuer)                       | Subject of the issuer of the x.509 certificate presented by the server.type: keywordexample: `CN=Example Root CA, OU=Infrastructure Team, DC=example, DC=com`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.server.issuer](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-issuer)                                                                                                                                                                                                                    | extended |
| [tls.server.ja3s](#field-tls-server-ja3s)                           | A hash that identifies servers based on how they perform an SSL/TLS handshake.type: keywordexample: `394441ab65754e2207b1e1b457b3641d`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.server.ja3s](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-ja3s)                                                                                                                                                                                                                                               | extended |
| [tls.server.not_after](#field-tls-server-not-after)                 | Timestamp indicating when server certificate is no longer considered valid.type: dateexample: `2021-01-01T00:00:00.000Z`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.server.not_after](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-not-after)                                                                                                                                                                                                                                                   | extended |
| [tls.server.not_before](#field-tls-server-not-before)               | Timestamp indicating when server certificate is first considered valid.type: dateexample: `1970-01-01T00:00:00.000Z`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.server.not_before](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-not-before)                                                                                                                                                                                                                                                     | extended |
| [tls.server.subject](#field-tls-server-subject)                     | Subject of the x.509 certificate presented by the server.type: keywordexample: `CN=www.example.com, OU=Infrastructure Team, DC=example, DC=com`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [tls.server.subject](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-subject)                                                                                                                                                                                                                                | extended |
| [tls.version](#field-tls-version)                                   | Numeric part of the version parsed from the original string.type: keywordexample: `1.2`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | extended |
| [tls.version_protocol](#field-tls-version-protocol)                 | Normalized lowercase protocol name parsed from original string.type: keywordexample: `tls`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |


### Field sets that can be nested under TLS


| Location            | Field Set                                                  | Description                                     |
|---------------------|------------------------------------------------------------|-------------------------------------------------|
| `tls.client.x509.*` | [x509](https://www.elastic.co/docs/reference/ecs/ecs-x509) | These fields contain x509 certificate metadata. |
| `tls.server.x509.*` | [x509](https://www.elastic.co/docs/reference/ecs/ecs-x509) | These fields contain x509 certificate metadata. |