﻿---
title: Threat fields
description: Fields to classify events and alerts according to a threat taxonomy such as the MITRE ATT&CK® framework. These fields are for users to classify alerts...
url: https://www.elastic.co/docs/reference/ecs/ecs-threat
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Threat fields
Fields to classify events and alerts according to a threat taxonomy such as the MITRE ATT&CK® framework.
These fields are for users to classify alerts from all of their sources (e.g. IDS, NGFW, etc.) within a common taxonomy. The threat.tactic.* fields are meant to capture the high level category of the threat (e.g. "impact"). The threat.technique.* fields are meant to capture which kind of approach is used by this detected threat, to accomplish the goal (e.g. "endpoint denial of service").

## Threat field details


| Field                                                                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                       | Level    |
|-------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [threat.enrichments](#field-threat-enrichments)                                                             | A list of associated indicators objects enriching the event, and the context of that association/enrichment.type: nestedNote: This field should contain an array of values.                                                                                                                                                                                                                                                                       | extended |
| [threat.enrichments.indicator](#field-threat-enrichments-indicator)                                         | Object containing associated indicators enriching the event.type: object                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [threat.enrichments.indicator.confidence](#field-threat-enrichments-indicator-confidence)                   | Identifies the vendor-neutral confidence rating using the None/Low/Medium/High scale defined in Appendix A of the STIX 2.1 framework. Vendor-specific confidence scales may be added as custom fields.Expected values for this field:* `Not Specified`* `None`* `Low`* `Medium`* `High`type: keywordexample: `Medium`                                                                                                                             | extended |
| [threat.enrichments.indicator.description](#field-threat-enrichments-indicator-description)                 | Describes the type of action conducted by the threat.type: keywordexample: `IP x.x.x.x was observed delivering the Angler EK.`                                                                                                                                                                                                                                                                                                                    | extended |
| [threat.enrichments.indicator.email.address](#field-threat-enrichments-indicator-email-address)             | Identifies a threat indicator as an email address (irrespective of direction).type: keywordexample: `phish@example.com`                                                                                                                                                                                                                                                                                                                           | extended |
| [threat.enrichments.indicator.first_seen](#field-threat-enrichments-indicator-first-seen)                   | The date and time when intelligence source first reported sighting this indicator.type: dateexample: `2020-11-05T17:25:47.000Z`                                                                                                                                                                                                                                                                                                                   | extended |
| [threat.enrichments.indicator.ip](#field-threat-enrichments-indicator-ip)                                   | Identifies a threat indicator as an IP address (irrespective of direction).type: ipexample: `1.2.3.4`                                                                                                                                                                                                                                                                                                                                             | extended |
| [threat.enrichments.indicator.last_seen](#field-threat-enrichments-indicator-last-seen)                     | The date and time when intelligence source last reported sighting this indicator.type: dateexample: `2020-11-05T17:25:47.000Z`                                                                                                                                                                                                                                                                                                                    | extended |
| [threat.enrichments.indicator.marking.tlp](#field-threat-enrichments-indicator-marking-tlp)                 | Traffic Light Protocol sharing markings.Expected values for this field:* `WHITE`* `CLEAR`* `GREEN`* `AMBER`* `AMBER+STRICT`* `RED`type: keywordexample: `CLEAR`                                                                                                                                                                                                                                                                                   | extended |
| [threat.enrichments.indicator.marking.tlp_version](#field-threat-enrichments-indicator-marking-tlp-version) | Traffic Light Protocol version.type: keywordexample: `2.0`                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [threat.enrichments.indicator.modified_at](#field-threat-enrichments-indicator-modified-at)                 | The date and time when intelligence source last modified information for this indicator.type: dateexample: `2020-11-05T17:25:47.000Z`                                                                                                                                                                                                                                                                                                             | extended |
| [threat.enrichments.indicator.name](#field-threat-enrichments-indicator-name)                               | The display name indicator in an UI friendly formatURL, IP address, email address, registry key, port number, hash value, or other relevant name can serve as the display name.type: keywordexample: `5.2.75.227`                                                                                                                                                                                                                                 | extended |
| [threat.enrichments.indicator.port](#field-threat-enrichments-indicator-port)                               | Identifies a threat indicator as a port number (irrespective of direction).type: longexample: `443`                                                                                                                                                                                                                                                                                                                                               | extended |
| [threat.enrichments.indicator.provider](#field-threat-enrichments-indicator-provider)                       | The name of the indicator's provider.type: keywordexample: `lrz_urlhaus`                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [threat.enrichments.indicator.reference](#field-threat-enrichments-indicator-reference)                     | Reference URL linking to additional information about this indicator.type: keywordexample: `https://system.example.com/indicator/0001234`                                                                                                                                                                                                                                                                                                         | extended |
| [threat.enrichments.indicator.scanner_stats](#field-threat-enrichments-indicator-scanner-stats)             | Count of AV/EDR vendors that successfully detected malicious file or URL.type: longexample: `4`                                                                                                                                                                                                                                                                                                                                                   | extended |
| [threat.enrichments.indicator.sightings](#field-threat-enrichments-indicator-sightings)                     | Number of times this indicator was observed conducting threat activity.type: longexample: `20`                                                                                                                                                                                                                                                                                                                                                    | extended |
| [threat.enrichments.indicator.type](#field-threat-enrichments-indicator-type)                               | Type of indicator as represented by Cyber Observable in STIX 2.0.Expected values for this field:* `autonomous-system`* `artifact`* `directory`* `domain-name`* `email-addr`* `file`* `ipv4-addr`* `ipv6-addr`* `mac-addr`* `mutex`* `port`* `process`* `software`* `url`* `user-account`* `windows-registry-key`* `x509-certificate`type: keywordexample: `ipv4-addr`                                                                             | extended |
| [threat.enrichments.matched.atomic](#field-threat-enrichments-matched-atomic)                               | Identifies the atomic indicator value that matched a local environment endpoint or network event.type: keywordexample: `bad-domain.com`                                                                                                                                                                                                                                                                                                           | extended |
| [threat.enrichments.matched.field](#field-threat-enrichments-matched-field)                                 | Identifies the field of the atomic indicator that matched a local environment endpoint or network event.type: keywordexample: `file.hash.sha256`                                                                                                                                                                                                                                                                                                  | extended |
| [threat.enrichments.matched.id](#field-threat-enrichments-matched-id)                                       | Identifies the _id of the indicator document enriching the event.type: keywordexample: `ff93aee5-86a1-4a61-b0e6-0cdc313d01b5`                                                                                                                                                                                                                                                                                                                     | extended |
| [threat.enrichments.matched.index](#field-threat-enrichments-matched-index)                                 | Identifies the _index of the indicator document enriching the event.type: keywordexample: `filebeat-8.0.0-2021.05.23-000011`                                                                                                                                                                                                                                                                                                                      | extended |
| [threat.enrichments.matched.occurred](#field-threat-enrichments-matched-occurred)                           | Indicates when the indicator match was generatedtype: dateexample: `2021-10-05T17:00:58.326Z`                                                                                                                                                                                                                                                                                                                                                     | extended |
| [threat.enrichments.matched.type](#field-threat-enrichments-matched-type)                                   | Identifies the type of match that caused the event to be enriched with the given indicatortype: keywordexample: `indicator_match_rule`                                                                                                                                                                                                                                                                                                            | extended |
| [threat.feed.dashboard_id](#field-threat-feed-dashboard-id)                                                 | The saved object ID of the dashboard belonging to the threat feed for displaying dashboard links to threat feeds in Kibana.type: keywordexample: `5ba16340-72e6-11eb-a3e3-b3cc7c78a70f`                                                                                                                                                                                                                                                           | extended |
| [threat.feed.description](#field-threat-feed-description)                                                   | Description of the threat feed in a UI friendly format.type: keywordexample: `Threat feed from the AlienVault Open Threat eXchange network.`                                                                                                                                                                                                                                                                                                      | extended |
| [threat.feed.name](#field-threat-feed-name)                                                                 | The name of the threat feed in UI friendly format.type: keywordexample: `AlienVault OTX`                                                                                                                                                                                                                                                                                                                                                          | extended |
| [threat.feed.reference](#field-threat-feed-reference)                                                       | Reference information for the threat feed in a UI friendly format.type: keywordexample: `https://otx.alienvault.com`                                                                                                                                                                                                                                                                                                                              | extended |
| [threat.framework](#field-threat-framework)                                                                 | Name of the threat framework used to further categorize and classify the tactic and technique of the reported threat. Framework classification can be provided by detecting systems, evaluated at ingest time, or retrospectively tagged to events.type: keywordexample: `MITRE ATT&CK`                                                                                                                                                           | extended |
| [threat.group.alias](#field-threat-group-alias)                                                             | The alias(es) of the group for a set of related intrusion activity that are tracked by a common name in the security community.While not required, you can use a MITRE ATT&CK® group alias(es).type: keywordNote: This field should contain an array of values.example: `[ "Magecart Group 6" ]`                                                                                                                                                  | extended |
| [threat.group.id](#field-threat-group-id)                                                                   | The id of the group for a set of related intrusion activity that are tracked by a common name in the security community.While not required, you can use a MITRE ATT&CK® group id.type: keywordexample: `G0037`                                                                                                                                                                                                                                    | extended |
| [threat.group.name](#field-threat-group-name)                                                               | The name of the group for a set of related intrusion activity that are tracked by a common name in the security community.While not required, you can use a MITRE ATT&CK® group name.type: keywordexample: `FIN6`                                                                                                                                                                                                                                 | extended |
| [threat.group.reference](#field-threat-group-reference)                                                     | The reference URL of the group for a set of related intrusion activity that are tracked by a common name in the security community.While not required, you can use a MITRE ATT&CK® group reference URL.type: keywordexample: `https://attack.mitre.org/groups/G0037/`                                                                                                                                                                             | extended |
| [threat.indicator.confidence](#field-threat-indicator-confidence)                                           | Identifies the vendor-neutral confidence rating using the None/Low/Medium/High scale defined in Appendix A of the STIX 2.1 framework. Vendor-specific confidence scales may be added as custom fields.Expected values for this field:* `Not Specified`* `None`* `Low`* `Medium`* `High`type: keywordexample: `Medium`                                                                                                                             | extended |
| [threat.indicator.description](#field-threat-indicator-description)                                         | Describes the type of action conducted by the threat.type: keywordexample: `IP x.x.x.x was observed delivering the Angler EK.`                                                                                                                                                                                                                                                                                                                    | extended |
| [threat.indicator.email.address](#field-threat-indicator-email-address)                                     | Identifies a threat indicator as an email address (irrespective of direction).type: keywordexample: `phish@example.com`                                                                                                                                                                                                                                                                                                                           | extended |
| [threat.indicator.first_seen](#field-threat-indicator-first-seen)                                           | The date and time when intelligence source first reported sighting this indicator.type: dateexample: `2020-11-05T17:25:47.000Z`                                                                                                                                                                                                                                                                                                                   | extended |
| [threat.indicator.id](#field-threat-indicator-id)                                                           | The ID of the indicator used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. This field can have multiple values to allow for the identification of the same indicator across systems that use different ID formats.While not required, a common approach is to use a STIX 2.x indicator ID.type: keywordNote: This field should contain an array of values.example: `[indicator--d7008e06-ab86-415a-9803-3c81ce2d3c37]` | extended |
| [threat.indicator.ip](#field-threat-indicator-ip)                                                           | Identifies a threat indicator as an IP address (irrespective of direction).type: ipexample: `1.2.3.4`                                                                                                                                                                                                                                                                                                                                             | extended |
| [threat.indicator.last_seen](#field-threat-indicator-last-seen)                                             | The date and time when intelligence source last reported sighting this indicator.type: dateexample: `2020-11-05T17:25:47.000Z`                                                                                                                                                                                                                                                                                                                    | extended |
| [threat.indicator.marking.tlp](#field-threat-indicator-marking-tlp)                                         | Traffic Light Protocol sharing markings.Expected values for this field:* `WHITE`* `CLEAR`* `GREEN`* `AMBER`* `AMBER+STRICT`* `RED`type: keywordexample: `CLEAR`                                                                                                                                                                                                                                                                                   | extended |
| [threat.indicator.marking.tlp_version](#field-threat-indicator-marking-tlp-version)                         | Traffic Light Protocol version.type: keywordexample: `2.0`                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [threat.indicator.modified_at](#field-threat-indicator-modified-at)                                         | The date and time when intelligence source last modified information for this indicator.type: dateexample: `2020-11-05T17:25:47.000Z`                                                                                                                                                                                                                                                                                                             | extended |
| [threat.indicator.name](#field-threat-indicator-name)                                                       | The display name indicator in an UI friendly formatURL, IP address, email address, registry key, port number, hash value, or other relevant name can serve as the display name.type: keywordexample: `5.2.75.227`                                                                                                                                                                                                                                 | extended |
| [threat.indicator.port](#field-threat-indicator-port)                                                       | Identifies a threat indicator as a port number (irrespective of direction).type: longexample: `443`                                                                                                                                                                                                                                                                                                                                               | extended |
| [threat.indicator.provider](#field-threat-indicator-provider)                                               | The name of the indicator's provider.type: keywordexample: `lrz_urlhaus`                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [threat.indicator.reference](#field-threat-indicator-reference)                                             | Reference URL linking to additional information about this indicator.type: keywordexample: `https://system.example.com/indicator/0001234`                                                                                                                                                                                                                                                                                                         | extended |
| [threat.indicator.scanner_stats](#field-threat-indicator-scanner-stats)                                     | Count of AV/EDR vendors that successfully detected malicious file or URL.type: longexample: `4`                                                                                                                                                                                                                                                                                                                                                   | extended |
| [threat.indicator.sightings](#field-threat-indicator-sightings)                                             | Number of times this indicator was observed conducting threat activity.type: longexample: `20`                                                                                                                                                                                                                                                                                                                                                    | extended |
| [threat.indicator.type](#field-threat-indicator-type)                                                       | Type of indicator as represented by Cyber Observable in STIX 2.0.Expected values for this field:* `autonomous-system`* `artifact`* `directory`* `domain-name`* `email-addr`* `file`* `ipv4-addr`* `ipv6-addr`* `mac-addr`* `mutex`* `port`* `process`* `software`* `url`* `user-account`* `windows-registry-key`* `x509-certificate`type: keywordexample: `ipv4-addr`                                                                             | extended |
| [threat.software.alias](#field-threat-software-alias)                                                       | The alias(es) of the software for a set of related intrusion activity that are tracked by a common name in the security community.While not required, you can use a MITRE ATT&CK® associated software description.type: keywordNote: This field should contain an array of values.example: `[ "X-Agent" ]`                                                                                                                                        | extended |
| [threat.software.id](#field-threat-software-id)                                                             | The id of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®.While not required, you can use a MITRE ATT&CK® software id.type: keywordexample: `S0552`                                                                                                                                                                                                                                                     | extended |
| [threat.software.name](#field-threat-software-name)                                                         | The name of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®.While not required, you can use a MITRE ATT&CK® software name.type: keywordexample: `AdFind`                                                                                                                                                                                                                                                | extended |
| [threat.software.platforms](#field-threat-software-platforms)                                               | The platforms of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®.While not required, you can use MITRE ATT&CK® software platform values.Expected values for this field:* `AWS`* `Azure`* `Azure AD`* `GCP`* `Linux`* `macOS`* `Network`* `Office 365`* `SaaS`* `Windows`type: keywordNote: This field should contain an array of values.example: `[ "Windows" ]`                                        | extended |
| [threat.software.reference](#field-threat-software-reference)                                               | The reference URL of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®.While not required, you can use a MITRE ATT&CK® software reference URL.type: keywordexample: `https://attack.mitre.org/software/S0552/`                                                                                                                                                                                            | extended |
| [threat.software.type](#field-threat-software-type)                                                         | The type of software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®.While not required, you can use a MITRE ATT&CK® software type.Expected values for this field:* `Malware`* `Tool`type: keywordexample: `Tool`                                                                                                                                                                                                    | extended |
| [threat.tactic.id](#field-threat-tactic-id)                                                                 | The id of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. [https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/) )type: keywordNote: This field should contain an array of values.example: `TA0002`                                                                                                                                                                               | extended |
| [threat.tactic.name](#field-threat-tactic-name)                                                             | Name of the type of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. [https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/))type: keywordNote: This field should contain an array of values.example: `Execution`                                                                                                                                                                   | extended |
| [threat.tactic.reference](#field-threat-tactic-reference)                                                   | The reference url of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. [https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/) )type: keywordNote: This field should contain an array of values.example: `https://attack.mitre.org/tactics/TA0002/`                                                                                                                                  | extended |
| [threat.technique.id](#field-threat-technique-id)                                                           | The id of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. [https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/))type: keywordNote: This field should contain an array of values.example: `T1059`                                                                                                                                                                       | extended |
| [threat.technique.name](#field-threat-technique-name)                                                       | The name of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. [https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/))type: keywordMulti-fields:* threat.technique.name.text (type: match_only_text)Note: This field should contain an array of values.example: `Command and Scripting Interpreter`                                                                        | extended |
| [threat.technique.reference](#field-threat-technique-reference)                                             | The reference url of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. [https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/))type: keywordNote: This field should contain an array of values.example: `https://attack.mitre.org/techniques/T1059/`                                                                                                                       | extended |
| [threat.technique.subtechnique.id](#field-threat-technique-subtechnique-id)                                 | The full id of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. [https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/))type: keywordNote: This field should contain an array of values.example: `T1059.001`                                                                                                                                                | extended |
| [threat.technique.subtechnique.name](#field-threat-technique-subtechnique-name)                             | The name of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. [https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/))type: keywordMulti-fields:* threat.technique.subtechnique.name.text (type: match_only_text)Note: This field should contain an array of values.example: `PowerShell`                                                                    | extended |
| [threat.technique.subtechnique.reference](#field-threat-technique-subtechnique-reference)                   | The reference url of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. [https://attack.mitre.org/techniques/T1059/001/](https://attack.mitre.org/techniques/T1059/001/))type: keywordNote: This field should contain an array of values.example: `https://attack.mitre.org/techniques/T1059/001/`                                                                                                     | extended |


### Field sets that can be nested under Threat


| Location                                  | Field Set                                                          | Description                                                       |
|-------------------------------------------|--------------------------------------------------------------------|-------------------------------------------------------------------|
| `threat.enrichments.indicator.as.*`       | [as](https://www.elastic.co/docs/reference/ecs/ecs-as)             | Fields describing an Autonomous System (Internet routing prefix). |
| `threat.enrichments.indicator.file.*`     | [file](https://www.elastic.co/docs/reference/ecs/ecs-file)         | Fields describing files.                                          |
| `threat.enrichments.indicator.geo.*`      | [geo](https://www.elastic.co/docs/reference/ecs/ecs-geo)           | Fields describing a location.                                     |
| `threat.enrichments.indicator.registry.*` | [registry](https://www.elastic.co/docs/reference/ecs/ecs-registry) | Fields related to Windows Registry operations.                    |
| `threat.enrichments.indicator.url.*`      | [url](https://www.elastic.co/docs/reference/ecs/ecs-url)           | Fields that let you store URLs in various forms.                  |
| `threat.enrichments.indicator.x509.*`     | [x509](https://www.elastic.co/docs/reference/ecs/ecs-x509)         | These fields contain x509 certificate metadata.                   |
| `threat.indicator.as.*`                   | [as](https://www.elastic.co/docs/reference/ecs/ecs-as)             | Fields describing an Autonomous System (Internet routing prefix). |
| `threat.indicator.file.*`                 | [file](https://www.elastic.co/docs/reference/ecs/ecs-file)         | Fields describing files.                                          |
| `threat.indicator.geo.*`                  | [geo](https://www.elastic.co/docs/reference/ecs/ecs-geo)           | Fields describing a location.                                     |
| `threat.indicator.registry.*`             | [registry](https://www.elastic.co/docs/reference/ecs/ecs-registry) | Fields related to Windows Registry operations.                    |
| `threat.indicator.url.*`                  | [url](https://www.elastic.co/docs/reference/ecs/ecs-url)           | Fields that let you store URLs in various forms.                  |
| `threat.indicator.x509.*`                 | [x509](https://www.elastic.co/docs/reference/ecs/ecs-x509)         | These fields contain x509 certificate metadata.                   |


### Threat field usage

For usage and examples of the threat fields, please see the [Threat fields usage and examples](https://www.elastic.co/docs/reference/ecs/ecs-threat-usage) section.