﻿---
title: Source fields
description: Source fields capture details about the sender of a network exchange/packet. These fields are populated from a network event, packet, or other event containing...
url: https://www.elastic.co/docs/reference/ecs/ecs-source
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Source fields
Source fields capture details about the sender of a network exchange/packet. These fields are populated from a network event, packet, or other event containing details of a network transaction.
Source fields are usually populated in conjunction with destination fields. The source and destination fields are considered the baseline and should always be filled if an event contains source and destination details from a network transaction. If the event also contains identification of the client and server roles, then the client and server fields should also be populated.

## Source field details


| Field                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Level    |
|-------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [source.address](#field-source-address)                     | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field.Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [source.address](https://opentelemetry.io/docs/specs/semconv/attributes-registry/source/#source-address) | extended |
| [source.bytes](#field-source-bytes)                         | Bytes sent from the source to the destination.type: longexample: `184`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | core     |
| [source.domain](#field-source-domain)                       | The domain name of the source system.This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.type: keywordexample: `foo.example.com`                                                                                                                                                                                                                                                                                                                                                                             | core     |
| [source.ip](#field-source-ip)                               | IP address of the source (IPv4 or IPv6).type: ip                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | core     |
| [source.mac](#field-source-mac)                             | MAC address of the source.The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.type: keywordexample: `00-00-5E-00-53-23`                                                                                                                                                                                                                                                                                                                    | core     |
| [source.nat.ip](#field-source-nat-ip)                       | Translated ip of source based NAT sessions (e.g. internal client to internet)Typically connections traversing load balancers, firewalls, or routers.type: ip                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [source.nat.port](#field-source-nat-port)                   | Translated port of source based NAT sessions. (e.g. internal client to internet)Typically used with load balancers, firewalls, or routers.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [source.packets](#field-source-packets)                     | Packets sent from the source to the destination.type: longexample: `12`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | core     |
| [source.port](#field-source-port)                           | Port of the source.type: long![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [source.port](https://opentelemetry.io/docs/specs/semconv/attributes-registry/source/#source-port)                                                                                                                                                                                                                                                              | core     |
| [source.registered_domain](#field-source-registered-domain) | The highest registered source domain, stripped of the subdomain.For example, the registered domain for "foo.example.com" is "example.com".This value can be determined precisely with a list like the public suffix list ([https://publicsuffix.org](https://publicsuffix.org)). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".type: keywordexample: `example.com`                                                                                                                                                                                               | extended |
| [source.subdomain](#field-source-subdomain)                 | The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.For example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.type: keywordexample: `east`                                                  | extended |
| [source.top_level_domain](#field-source-top-level-domain)   | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".This value can be determined precisely with a list like the public suffix list ([https://publicsuffix.org](https://publicsuffix.org)). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".type: keywordexample: `co.uk`                                                                                                                                                                  | extended |


## Field reuse

The `source` fields are expected to be nested at:
- `process.entry_meta.source`

Note also that the `source` fields may be used directly at the root of the events.

### Field sets that can be nested under Source


| Location        | Field Set                                                  | Description                                                       |
|-----------------|------------------------------------------------------------|-------------------------------------------------------------------|
| `source.as.*`   | [as](https://www.elastic.co/docs/reference/ecs/ecs-as)     | Fields describing an Autonomous System (Internet routing prefix). |
| `source.geo.*`  | [geo](https://www.elastic.co/docs/reference/ecs/ecs-geo)   | Fields describing a location.                                     |
| `source.user.*` | [user](https://www.elastic.co/docs/reference/ecs/ecs-user) | Fields to describe the user relevant to the event.                |