﻿---
title: Service fields
description: The service fields describe the service for or from which the data was collected. These fields help you find and correlate logs for a specific service...
url: https://www.elastic.co/docs/reference/ecs/ecs-service
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Service fields
The service fields describe the service for or from which the data was collected.
These fields help you find and correlate logs for a specific service and version.

## Service field details


| Field                                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Level    |
|-----------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [service.address](#field-service-address)           | Address where data about this service was collected from.This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).type: keywordexample: `172.26.0.2:5432`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [service.environment](#field-service-environment)   | _This field is beta and subject to change._ Identifies the environment where the service is running.If the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment.type: keywordexample: `production`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [deployment.environment.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/deployment/#deployment-environment-name)                                                                                                                                                                                                                                                                                                           | extended |
| [service.ephemeral_id](#field-service-ephemeral-id) | Ephemeral identifier of this service (if one exists).This id normally changes across restarts, but `service.id` does not.type: keywordexample: `8a4f500f`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [service.id](#field-service-id)                     | Unique identifier of the running service. If the service is comprised of many nodes, the `service.id` should be the same for all nodes.This id should uniquely identify the service. This makes it possible to correlate logs and metrics for one specific service, no matter which particular node emitted the event.Note that if you need to see the events from one specific host of the service, you should filter on that `host.name` or `host.id` instead.type: keywordexample: `d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | core     |
| [service.name](#field-service-name)                 | Name of the service data is collected from.The name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name.In the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified.type: keywordexample: `elasticsearch-metrics`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [service.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/service/#service-name)                                                                                                                                                                                                                                                                               | core     |
| [service.node.name](#field-service-node-name)       | Name of a service node.This allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service.In the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set.type: keywordexample: `instance-0000000016`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [service.instance.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/service/#service-instance-id) | extended |
| [service.node.role](#field-service-node-role)       | Deprecated for removal in next major version release. This field will be superseded by `node.roles`.Role of a service node.This allows for distinction between different running roles of the same service.In the case of Kibana, the `service.node.role` could be `ui` or `background_tasks`.In the case of Elasticsearch, the `service.node.role` could be `master` or `data`.Other services could use this to distinguish between a `web` and `worker` role running as part of the service.type: keywordexample: `background_tasks`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [service.node.roles](#field-service-node-roles)     | Roles of a service node.This allows for distinction between different running roles of the same service.In the case of Kibana, the `service.node.role` could be `ui` or `background_tasks` or both.In the case of Elasticsearch, the `service.node.role` could be `master` or `data` or both.Other services could use this to distinguish between a `web` and `worker` role running as part of the service.type: keywordNote: This field should contain an array of values.example: `["ui", "background_tasks"]`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | extended |
| [service.state](#field-service-state)               | Current state of the service.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | core     |
| [service.type](#field-service-type)                 | The type of the service data is collected from.The type can be used to group and correlate logs and metrics from one service type.Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.type: keywordexample: `elasticsearch`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | core     |
| [service.version](#field-service-version)           | Version of the service the data was collected from.This allows to look at a data set only for a specific version of a service.type: keywordexample: `3.2.4`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [service.version](https://opentelemetry.io/docs/specs/semconv/attributes-registry/service/#service-version)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | core     |


## Field reuse

The `service` fields are expected to be nested at:
- `service.origin`
- `service.target`

Note also that the `service` fields may be used directly at the root of the events.

### Field sets that can be nested under Service


| Location           | Field Set                                                        | Description                                                                                                                                         |
|--------------------|------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------|
| `service.entity.*` | [entity](https://www.elastic.co/docs/reference/ecs/ecs-entity)   | Fields to describe various types of entities across IT environments.                                                                                |
| `service.origin.*` | [service](https://www.elastic.co/docs/reference/ecs/ecs-service) | _Reusing the `service` fields in this location is currently considered beta._ Describes the origin service in case of an incoming request or event. |
| `service.target.*` | [service](https://www.elastic.co/docs/reference/ecs/ecs-service) | _Reusing the `service` fields in this location is currently considered beta._ Describes the target service in case of an outgoing request or event. |


### Service field usage

For usage and examples of the service fields, please see the [Service fields usage and examples](https://www.elastic.co/docs/reference/ecs/ecs-service-usage) section.