﻿---
title: Service fields usage and examples
description: Here are the subjects covered in this page. Field reuse. The service fields can be used to * describe the service for or from which the data was collected...
url: https://www.elastic.co/docs/reference/ecs/ecs-service-usage
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Service fields usage and examples
Here are the subjects covered in this page.
- [Field reuse](#ecs-service-usage-field-reuse)
  - [Service fields at the Root of an Event](#ecs-service-usage-service-at-root)
- [Describing external services in an invocation relationship](#ecs-service-usage-origin-target)


## Field reuse

The service fields can be used to * [describe the service for or from which the data was collected](#ecs-service-usage-service-at-root) (i.e. observed service) * or to [describe external services that have a direct invocation relationship](#ecs-service-usage-origin-target) to the observed service

### Service fields at the root of an event

Use the service fields at the root of an event to describe the service the event primarily relates to. An example for this use case is a log entry being recorded for a particular service or appplication (e.g. `MyService`):
```json
{
  "service": { 
    "id": "d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6",
    "name": "MyService",
    "version": "1.0.0"
  },
  ...
}
```


### Describing external services in an invocation relationship

Multiple services can be in an invocation relationship. Where it is possible to apply [distributed tracing](https://www.elastic.co/docs/solutions/observability/apm/traces-ui) on all the involved services describe the individual services [using root-level service fields](#ecs-service-usage-service-at-root) and use the [tracing fields](https://www.elastic.co/docs/reference/ecs/ecs-related) to represent the invocation relationship.
There are situations when distributed tracing cannot be applied on some external services that are in an invocation relationship to an observed service. Let’s consider the example of a service `MyService` being deployed on a cloud provider with an upstream API gateway that passes through requests to `MyService` (with additional context information about the API gateway itself). To describe the API gateway as a service from the perspective of `MyService` one can self-nest the service fields under `service.origin`:
```json
{
  "service": { 
    "id": "d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6",
    "name": "MyService",
    "version": "1.0.0",
    "origin": { 
      "id": "api-gateway-46372994637e2b4567",
      "name": "SomeGateway",
      "version" "2.5.1",
    }
  },
  ...
}
```

Similar to the usage of `service.origin` fields the service fields can be self-nested under `service.target.*` to describe an external target service for an outbound request:
```json
{
  "service": { 
    "id": "d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6",
    "name": "MyService",
    "version": "1.0.0",
    "target": { 
      "id": "sms-service-0xe6c4272dbeAf0134",
      "name": "ManagedSMSService",
      "version": "1.9.0",
    }
  },
  ...
}
```

Note that `service.origin.*` and `service.target.*` fields should only be used on events that represent an invocation relationship.