﻿---
title: Server fields
description: A Server is defined as the responder in a network connection for events regarding sessions, connections, or bidirectional flow records. For TCP events,...
url: https://www.elastic.co/docs/reference/ecs/ecs-server
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Server fields
A Server is defined as the responder in a network connection for events regarding sessions, connections, or bidirectional flow records.
For TCP events, the server is the receiver of the initial SYN packet(s) of the TCP connection. For other protocols, the server is generally the responder in the network transaction. Some systems actually use the term "responder" to refer the server in TCP connections. The server fields describe details about the system acting as the server in the network event. Server fields are usually populated in conjunction with client fields. Server fields are generally not populated for packet-level events.
Client / server representations can add semantic context to an exchange, which is helpful to visualize the data in certain situations. If your context falls in that category, you should still ensure that source and destination are filled appropriately.

## Server field details


| Field                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Level    |
|-------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [server.address](#field-server-address)                     | Some event server addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field.Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [server.address](https://opentelemetry.io/docs/specs/semconv/attributes-registry/server/#server-address) | extended |
| [server.bytes](#field-server-bytes)                         | Bytes sent from the server to the client.type: longexample: `184`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | core     |
| [server.domain](#field-server-domain)                       | The domain name of the server system.This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.type: keywordexample: `foo.example.com`                                                                                                                                                                                                                                                                                                                                                                             | core     |
| [server.ip](#field-server-ip)                               | IP address of the server (IPv4 or IPv6).type: ip                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | core     |
| [server.mac](#field-server-mac)                             | MAC address of the server.The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.type: keywordexample: `00-00-5E-00-53-23`                                                                                                                                                                                                                                                                                                                    | core     |
| [server.nat.ip](#field-server-nat-ip)                       | Translated ip of destination based NAT sessions (e.g. internet to private DMZ)Typically used with load balancers, firewalls, or routers.type: ip                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [server.nat.port](#field-server-nat-port)                   | Translated port of destination based NAT sessions (e.g. internet to private DMZ)Typically used with load balancers, firewalls, or routers.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [server.packets](#field-server-packets)                     | Packets sent from the server to the client.type: longexample: `12`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | core     |
| [server.port](#field-server-port)                           | Port of the server.type: long![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [server.port](https://opentelemetry.io/docs/specs/semconv/attributes-registry/server/#server-port)                                                                                                                                                                                                                                                              | core     |
| [server.registered_domain](#field-server-registered-domain) | The highest registered server domain, stripped of the subdomain.For example, the registered domain for "foo.example.com" is "example.com".This value can be determined precisely with a list like the public suffix list ([https://publicsuffix.org](https://publicsuffix.org)). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".type: keywordexample: `example.com`                                                                                                                                                                                               | extended |
| [server.subdomain](#field-server-subdomain)                 | The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.For example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.type: keywordexample: `east`                                                  | extended |
| [server.top_level_domain](#field-server-top-level-domain)   | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".This value can be determined precisely with a list like the public suffix list ([https://publicsuffix.org](https://publicsuffix.org)). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".type: keywordexample: `co.uk`                                                                                                                                                                  | extended |


### Field sets that can be nested under Server


| Location        | Field Set                                                  | Description                                                       |
|-----------------|------------------------------------------------------------|-------------------------------------------------------------------|
| `server.as.*`   | [as](https://www.elastic.co/docs/reference/ecs/ecs-as)     | Fields describing an Autonomous System (Internet routing prefix). |
| `server.geo.*`  | [geo](https://www.elastic.co/docs/reference/ecs/ecs-geo)   | Fields describing a location.                                     |
| `server.user.*` | [user](https://www.elastic.co/docs/reference/ecs/ecs-user) | Fields to describe the user relevant to the event.                |