﻿---
title: Rule fields
description: Rule fields are used to capture the specifics of any observer or agent rules that generate alerts or other notable events. Examples of data sources that...
url: https://www.elastic.co/docs/reference/ecs/ecs-rule
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Rule fields
Rule fields are used to capture the specifics of any observer or agent rules that generate alerts or other notable events.
Examples of data sources that would populate the rule fields include: network admission control platforms, network or host IDS/IPS, network firewalls, web application firewalls, url filters, endpoint detection and response (EDR) systems, etc.

## Rule field details


| Field                                       | Description                                                                                                                                                                                                                                                                                                               | Level    |
|---------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [rule.author](#field-rule-author)           | Name, organization, or pseudonym of the author or authors who created the rule used to generate this event.type: keywordNote: This field should contain an array of values.example: `["Star-Lord"]`                                                                                                                       | extended |
| [rule.category](#field-rule-category)       | A categorization value keyword used by the entity using the rule for detection of this event.type: keywordexample: `Attempted Information Leak`                                                                                                                                                                           | extended |
| [rule.description](#field-rule-description) | The description of the rule generating the event.type: keywordexample: `Block requests to public DNS over HTTPS / TLS protocols`                                                                                                                                                                                          | extended |
| [rule.id](#field-rule-id)                   | A rule ID that is unique within the scope of an agent, observer, or other entity using the rule for detection of this event.type: keywordexample: `101`                                                                                                                                                                   | extended |
| [rule.license](#field-rule-license)         | Name of the license under which the rule used to generate this event is made available.type: keywordexample: `Apache 2.0`                                                                                                                                                                                                 | extended |
| [rule.name](#field-rule-name)               | The name of the rule or signature generating the event.type: keywordexample: `BLOCK_DNS_over_TLS`                                                                                                                                                                                                                         | extended |
| [rule.reference](#field-rule-reference)     | Reference URL to additional information about the rule used to generate this event.The URL can point to the vendor's documentation about the rule. If that's not available, it can also be a link to a more general page describing this type of alert.type: keywordexample: `https://en.wikipedia.org/wiki/DNS_over_TLS` | extended |
| [rule.ruleset](#field-rule-ruleset)         | Name of the ruleset, policy, group, or parent category in which the rule used to generate this event is a member.type: keywordexample: `Standard_Protocol_Filters`                                                                                                                                                        | extended |
| [rule.uuid](#field-rule-uuid)               | A rule ID that is unique within the scope of a set or group of agents, observers, or other entities using the rule for detection of this event.type: keywordexample: `1100110011`                                                                                                                                         | extended |
| [rule.version](#field-rule-version)         | The version / revision of the rule being used for analysis.type: keywordexample: `1.1`                                                                                                                                                                                                                                    | extended |