﻿---
title: Risk information fields
description: Fields for describing risk score and risk level of entities such as hosts and users. These fields are not allowed to be nested under event.*. Please continue...
url: https://www.elastic.co/docs/reference/ecs/ecs-risk
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Risk information fields
Fields for describing risk score and risk level of entities such as hosts and users. These fields are not allowed to be nested under `event.*`. Please continue to use `event.risk_score` and `event.risk_score_norm` for event risk.
<warning>
  These fields are in beta and are subject to change.
</warning>


## Risk information field details


| Field                                                           | Description                                                                                                                                                                             | Level    |
|-----------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [risk.calculated_level](#field-risk-calculated-level)           | A risk classification level calculated by an internal system as part of entity analytics and entity risk scoring.type: keywordexample: `High`                                           | extended |
| [risk.calculated_score](#field-risk-calculated-score)           | A risk classification score calculated by an internal system as part of entity analytics and entity risk scoring.type: floatexample: `880.73`                                           | extended |
| [risk.calculated_score_norm](#field-risk-calculated-score-norm) | A risk classification score calculated by an internal system as part of entity analytics and entity risk scoring, and normalized to a range of 0 to 100.type: floatexample: `88.73`     | extended |
| [risk.static_level](#field-risk-static-level)                   | A risk classification level obtained from outside the system, such as from some external Threat Intelligence Platform.type: keywordexample: `High`                                      | extended |
| [risk.static_score](#field-risk-static-score)                   | A risk classification score obtained from outside the system, such as from some external Threat Intelligence Platform.type: floatexample: `830.0`                                       | extended |
| [risk.static_score_norm](#field-risk-static-score-norm)         | A risk classification score obtained from outside the system, such as from some external Threat Intelligence Platform, and normalized to a range of 0 to 100.type: floatexample: `83.0` | extended |


## Field reuse

The `risk` fields are expected to be nested at:
- `host.risk`
- `user.risk`

Note also that the `risk` fields are not expected to be used directly at the root of the events.