﻿---
title: Related fields
description: This field set is meant to facilitate pivoting around a piece of data. Some pieces of information can be seen in many places in an ECS event. To facilitate...
url: https://www.elastic.co/docs/reference/ecs/ecs-related
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Related fields
This field set is meant to facilitate pivoting around a piece of data.
Some pieces of information can be seen in many places in an ECS event. To facilitate searching for them, store an array of all seen values to their corresponding field in `related.`.
A concrete example is IP addresses, which can be under host, observer, source, destination, client, server, and network.forwarded_ip. If you append all IPs to `related.ip`, you can then search for a given IP trivially, no matter where it appeared, by querying `related.ip:192.0.2.15`.

## Related field details


| Field                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Level    |
|---------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [related.hash](#field-related-hash)   | All the hashes seen on your event. Populating this field, then using it to search for hashes can help in situations where you're unsure what the hash algorithm is (and therefore which key name to search).type: keywordNote: This field should contain an array of values.![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) Not applicable. | extended |
| [related.hosts](#field-related-hosts) | All hostnames or other host identifiers seen on your event. Example identifiers include FQDNs, domain names, workstation names, or aliases.type: keywordNote: This field should contain an array of values.![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) Not applicable.                                                                  | extended |
| [related.ip](#field-related-ip)       | All of the IPs seen on your event.type: ipNote: This field should contain an array of values.![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) Not applicable.                                                                                                                                                                                | extended |
| [related.user](#field-related-user)   | All the user names or other user identifiers seen on the event.type: keywordNote: This field should contain an array of values.![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) Not applicable.                                                                                                                                              | extended |