﻿---
title: Registry fields
description: Fields related to Windows Registry operations. The registry fields are expected to be nested at: threat.enrichments.indicator.registry, threat.indicator.registry...
url: https://www.elastic.co/docs/reference/ecs/ecs-registry
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Registry fields
Fields related to Windows Registry operations.

## Registry field details


| Field                                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Level    |
|-------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [registry.data.bytes](#field-registry-data-bytes)     | Original bytes written with base64 encoding.For Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values.type: keywordexample: `ZQBuAC0AVQBTAAAAZQBuAAAAAAA=`                                                                                                                                                                                   | extended |
| [registry.data.strings](#field-registry-data-strings) | Content when writing string types.Populated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`).type: wildcardNote: This field should contain an array of values.example: `["C:\rta\red_ttp\bin\myapp.exe"]` | core     |
| [registry.data.type](#field-registry-data-type)       | Standard registry type for encoding contentstype: keywordexample: `REG_SZ`                                                                                                                                                                                                                                                                                                                                                                                                                                               | core     |
| [registry.hive](#field-registry-hive)                 | Abbreviated name for the hive.type: keywordexample: `HKLM`                                                                                                                                                                                                                                                                                                                                                                                                                                                               | core     |
| [registry.key](#field-registry-key)                   | Hive-relative path of keys.type: keywordexample: `SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\winword.exe`                                                                                                                                                                                                                                                                                                                                                                                 | core     |
| [registry.path](#field-registry-path)                 | Full path, including hive, key and valuetype: keywordexample: `HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\winword.exe\Debugger`                                                                                                                                                                                                                                                                                                                                                      | core     |
| [registry.value](#field-registry-value)               | Name of the value written.type: keywordexample: `Debugger`                                                                                                                                                                                                                                                                                                                                                                                                                                                               | core     |


## Field reuse

The `registry` fields are expected to be nested at:
- `threat.enrichments.indicator.registry`
- `threat.indicator.registry`

Note also that the `registry` fields may be used directly at the root of the events.