﻿---
title: Products and solutions that support ECS
description: The following Elastic products support ECS out of the box, as of version 7.0: Beats, APM, Elastic Security, Elastic Endpoint Security Server, Log Monitoring,...
url: https://www.elastic.co/docs/reference/ecs/ecs-products-solutions
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Products and solutions that support ECS
The following Elastic products support ECS out of the box, as of version 7.0:
- [Beats](https://www.elastic.co/docs/reference/beats)
- [APM](https://www.elastic.co/docs/solutions/observability/apm)
- [Elastic Security](https://www.elastic.co/docs/solutions/security)
  - [Elastic Security Field Reference](https://www.elastic.co/docs/reference/security/fields-and-object-schemas/siem-field-reference) - a list of ECS fields used in the Security app
- [Elastic Endpoint Security Server](https://www.elastic.co/products/endpoint-security)
- [Log Monitoring](https://www.elastic.co/docs/solutions/observability/logs/explore-logs)
- Log formatters that support ECS out of the box for various languages can be found [here](https://github.com/elastic/ecs-logging/blob/master/README.md).
- [Metrics Monitoring](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics)
- Logstash' Elasticsearch output has an [ECS compatibility mode](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch#_compatibility_with_the_elastic_common_schema_ecs)