﻿---
title: Process fields
description: These fields contain information about a process. These fields can help you correlate metrics information with a process id/name from a log message...
url: https://www.elastic.co/docs/reference/ecs/ecs-process
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Process fields
These fields contain information about a process.
These fields can help you correlate metrics information with a process id/name from a log message.  The `process.pid` often stays in the metric itself and is copied to the global field for correlation.

## Process field details


| Field                                                                                         | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Level    |
|-----------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [process.args](#field-process-args)                                                           | Array of process arguments, starting with the absolute path to the executable.May be filtered to protect sensitive information.type: keywordNote: This field should contain an array of values.example: `["/usr/bin/ssh", "-l", "user", "10.0.0.16"]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [process.command_args](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-command-args)                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [process.args_count](#field-process-args-count)                                               | Length of the process.args array.This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.type: longexample: `4`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [process.args_count](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-args-count)                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [process.command_line](#field-process-command-line)                                           | Full command line that started the process, including the absolute path to the executable, and all arguments.Some arguments may be filtered to protect sensitive information.type: wildcardMulti-fields:* process.command_line.text (type: match_only_text)example: `/usr/bin/ssh -l user 10.0.0.16`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [process.command_line](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-command-line)                                                                                                                                                                                                                                                                                                                                              | extended |
| [process.end](#field-process-end)                                                             | The time the process ended.type: dateexample: `2016-05-23T08:05:34.853Z`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [process.entity_id](#field-process-entity-id)                                                 | Unique identifier for the process.The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.type: keywordexample: `c2c455d9f99375d`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [process.env_vars](#field-process-env-vars)                                                   | Array of environment variable bindings. Captured from a snapshot of the environment at the time of execution.May be filtered to protect sensitive information.type: keywordNote: This field should contain an array of values.example: `["PATH=/usr/local/bin:/usr/bin", "USER=ubuntu"]`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [process.executable](#field-process-executable)                                               | Absolute path to the process executable.type: keywordMulti-fields:* process.executable.text (type: match_only_text)example: `/usr/bin/ssh`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [process.executable.path](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-executable-path)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [process.exit_code](#field-process-exit-code)                                                 | The exit code of the process, if this is a termination event.The field should be absent if there is no exit code for the event (e.g. process start).type: longexample: `137`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [process.interactive](#field-process-interactive)                                             | Whether the process is connected to an interactive shell.Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive.Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY.type: booleanexample: `True`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [process.interactive](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-interactive) | extended |
| [process.io](#field-process-io)                                                               | A chunk of input or output (IO) from a single process.This field only appears on the top level process object, which is the process that wrote the output or read the input.type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [process.io.bytes_skipped](#field-process-io-bytes-skipped)                                   | An array of byte offsets and lengths denoting where IO data has been skipped.type: objectNote: This field should contain an array of values.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [process.io.bytes_skipped.length](#field-process-io-bytes-skipped-length)                     | The length of bytes skipped.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [process.io.bytes_skipped.offset](#field-process-io-bytes-skipped-offset)                     | The byte offset into this event's io.text (or io.bytes in the future) where length bytes were skipped.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | extended |
| [process.io.max_bytes_per_process_exceeded](#field-process-io-max-bytes-per-process-exceeded) | If true, the process producing the output has exceeded the max_kilobytes_per_process configuration setting.type: boolean                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [process.io.text](#field-process-io-text)                                                     | A chunk of output or input sanitized to UTF-8.Best efforts are made to ensure complete lines are captured in these events. Assumptions should NOT be made that multiple lines will appear in the same event. TTY output may contain terminal control codes such as for cursor movement, so some string queries may not match due to terminal codes inserted between characters of a word.type: wildcard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [process.io.total_bytes_captured](#field-process-io-total-bytes-captured)                     | The total number of bytes captured in this event.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [process.io.total_bytes_skipped](#field-process-io-total-bytes-skipped)                       | The total number of bytes that were not captured due to implementation restrictions such as buffer size limits. Implementors should strive to ensure this value is always zerotype: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [process.io.type](#field-process-io-type)                                                     | The type of object on which the IO action (read or write) was taken.Currently only 'tty' is supported. Other types may be added in the future for 'file' and 'socket' support.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [process.name](#field-process-name)                                                           | Process name.Sometimes called program name or similar.type: keywordMulti-fields:* process.name.text (type: match_only_text)example: `ssh`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [process.pid](#field-process-pid)                                                             | Process id.type: longexample: `4242`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [process.pid](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-pid)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | core     |
| [process.start](#field-process-start)                                                         | The time the process started.type: dateexample: `2016-05-23T08:05:34.853Z`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [process.thread.capabilities.effective](#field-process-thread-capabilities-effective)         | This is the set of capabilities used by the kernel to perform permission checks for the thread.type: keywordNote: This field should contain an array of values.example: `["CAP_BPF", "CAP_SYS_ADMIN"]`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [process.thread.capabilities.permitted](#field-process-thread-capabilities-permitted)         | This is a limiting superset for the effective capabilities that the thread may assume.type: keywordNote: This field should contain an array of values.example: `["CAP_BPF", "CAP_SYS_ADMIN"]`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | extended |
| [process.thread.id](#field-process-thread-id)                                                 | Thread ID.type: longexample: `4242`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | extended |
| [process.thread.name](#field-process-thread-name)                                             | Thread name.type: keywordexample: `thread-0`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [process.title](#field-process-title)                                                         | Process title.The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened.type: keywordMulti-fields:* process.title.text (type: match_only_text)![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [process.title](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-title)                                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [process.tty](#field-process-tty)                                                             | Information about the controlling TTY device. If set, the process belongs to an interactive session.type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | extended |
| [process.tty.char_device.major](#field-process-tty-char-device-major)                         | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation.type: longexample: `4`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [process.tty.char_device.minor](#field-process-tty-char-device-minor)                         | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them.type: longexample: `1`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | extended |
| [process.tty.columns](#field-process-tty-columns)                                             | The number of character columns per line. e.g terminal widthTerminal sizes can change, so this value reflects the maximum value for a given IO event. i.e. where event.action = 'text_output'type: longexample: `80`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | extended |
| [process.tty.rows](#field-process-tty-rows)                                                   | The number of character rows in the terminal. e.g terminal heightTerminal sizes can change, so this value reflects the maximum value for a given IO event. i.e. where event.action = 'text_output'type: longexample: `24`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [process.uptime](#field-process-uptime)                                                       | Seconds the process has been up.type: longexample: `1325`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [process.uptime](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.process.uptime+--%3E%22&type=code)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | extended |
| [process.vpid](#field-process-vpid)                                                           | Virtual process id.The process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.type: longexample: `4242`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [process.vpid](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-vpid)                                                                                                                                                                                                                                                                                                                                                                                                                                  | core     |
| [process.working_directory](#field-process-working-directory)                                 | The working directory of the process.type: keywordMulti-fields:* process.working_directory.text (type: match_only_text)example: `/home/alice`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [process.working_directory](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-working-directory)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |


## Field reuse

The `process` fields are expected to be nested at:
- `process.entry_leader`
- `process.entry_leader.parent`
- `process.entry_leader.parent.session_leader`
- `process.group_leader`
- `process.parent`
- `process.parent.group_leader`
- `process.previous`
- `process.responsible`
- `process.session_leader`
- `process.session_leader.parent`
- `process.session_leader.parent.session_leader`

Note also that the `process` fields may be used directly at the root of the events.

### Field sets that can be nested under Process


| Location                                         | Field Set                                                                      | Description                                                                                                                                                                                                                          |
|--------------------------------------------------|--------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `process.attested_groups.*`                      | [group](https://www.elastic.co/docs/reference/ecs/ecs-group)                   | _Reusing the `group` fields in this location is currently considered beta._ The externally attested groups based on an external source such as the Kube API.**Note:** This reuse should contain an array of group field set objects. |
| `process.attested_user.*`                        | [user](https://www.elastic.co/docs/reference/ecs/ecs-user)                     | _Reusing the `user` fields in this location is currently considered beta._ The externally attested user based on an external source such as the Kube API.                                                                            |
| `process.code_signature.*`                       | [code_signature](https://www.elastic.co/docs/reference/ecs/ecs-code_signature) | These fields contain information about binary code signatures.                                                                                                                                                                       |
| `process.elf.*`                                  | [elf](https://www.elastic.co/docs/reference/ecs/ecs-elf)                       | These fields contain Linux Executable Linkable Format (ELF) metadata.                                                                                                                                                                |
| `process.entry_leader.*`                         | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | First process from terminal or remote access via SSH, SSM, etc OR a service directly started by the init process.                                                                                                                    |
| `process.entry_leader.parent.*`                  | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | Information about the entry leader's parent process. Only pid, start and entity_id fields are set.                                                                                                                                   |
| `process.entry_leader.parent.session_leader.*`   | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | Information about the parent session of the entry leader. Only pid, start and entity_id fields are set.                                                                                                                              |
| `process.entry_meta.source.*`                    | [source](https://www.elastic.co/docs/reference/ecs/ecs-source)                 | Remote client information such as ip, port and geo location.                                                                                                                                                                         |
| `process.group.*`                                | [group](https://www.elastic.co/docs/reference/ecs/ecs-group)                   | The effective group (egid).                                                                                                                                                                                                          |
| `process.group_leader.*`                         | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | Information about the process group leader. In some cases this may be the same as the top level process.                                                                                                                             |
| `process.hash.*`                                 | [hash](https://www.elastic.co/docs/reference/ecs/ecs-hash)                     | Hashes, usually file hashes.                                                                                                                                                                                                         |
| `process.macho.*`                                | [macho](https://www.elastic.co/docs/reference/ecs/ecs-macho)                   | _This field reuse is beta and subject to change._ These fields contain Mac OS Mach Object file format (Mach-O) metadata.                                                                                                             |
| `process.parent.*`                               | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | Information about the parent process.                                                                                                                                                                                                |
| `process.parent.group_leader.*`                  | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | Information about the parent's process group leader. Only pid, start and entity_id fields are set.                                                                                                                                   |
| `process.pe.*`                                   | [pe](https://www.elastic.co/docs/reference/ecs/ecs-pe)                         | These fields contain Windows Portable Executable (PE) metadata.                                                                                                                                                                      |
| `process.previous.*`                             | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | An array of previous executions for the process, including the initial fork. Only executable and args are set.**Note:** This reuse should contain an array of process field set objects.                                             |
| `process.real_group.*`                           | [group](https://www.elastic.co/docs/reference/ecs/ecs-group)                   | The real group (rgid).                                                                                                                                                                                                               |
| `process.real_user.*`                            | [user](https://www.elastic.co/docs/reference/ecs/ecs-user)                     | The real user (ruid). Identifies the real owner of the process.                                                                                                                                                                      |
| `process.responsible.*`                          | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | _This field is beta and subject to change._ Responsible process in macOS tracks the originating process of an app, key for understanding permissions and hierarchy.                                                                  |
| `process.saved_group.*`                          | [group](https://www.elastic.co/docs/reference/ecs/ecs-group)                   | The saved group (sgid).                                                                                                                                                                                                              |
| `process.saved_user.*`                           | [user](https://www.elastic.co/docs/reference/ecs/ecs-user)                     | The saved user (suid).                                                                                                                                                                                                               |
| `process.session_leader.*`                       | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | Often the same as entry_leader. When it differs, it represents a session started within another session. e.g. using tmux                                                                                                             |
| `process.session_leader.parent.*`                | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | Information about the session leader's parent process. Only pid, start and entity_id fields are set.                                                                                                                                 |
| `process.session_leader.parent.session_leader.*` | [process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | Information about the parent session of the session leader. Only pid, start and entity_id fields are set.                                                                                                                            |
| `process.supplemental_groups.*`                  | [group](https://www.elastic.co/docs/reference/ecs/ecs-group)                   | An array of supplemental groups.**Note:** This reuse should contain an array of group field set objects.                                                                                                                             |
| `process.user.*`                                 | [user](https://www.elastic.co/docs/reference/ecs/ecs-user)                     | The effective user (euid).                                                                                                                                                                                                           |