﻿---
title: Implementation patterns
description: Normalizing data provides a more consistent view of events from various data sources. Following these conventions will help to better describe, discover,...
url: https://www.elastic.co/docs/reference/ecs/ecs-principles-implementation
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Implementation patterns
Normalizing data provides a more consistent view of events from various data sources. Following these conventions will help to better describe, discover, identify, and categorize events.

## Base fields

The group of individual fields residing outside any field set at the top-level of ECS are known as base fields.
ECS events follow these conventions with the base fields:
<definitions>
  <definition term="@timestamp">
    All events must populate [`@timestamp`](/docs/reference/ecs/ecs-base#field-timestamp) with the event’s original timestamp.
  </definition>
  <definition term="message">
    Most events should populate [`message`](/docs/reference/ecs/ecs-base#field-message).
  </definition>
  <definition term="ecs.version">
    The referenced [`ecs.version`](/docs/reference/ecs/ecs-ecs#field-ecs-version) used to develop the data mapping or ingest pipeline. This value helps detect when mappings update or fall behind. It can also help explain why a particular data source isn’t populating the same fields as another.
  </definition>
  <definition term="tags and labels">
    The [`tags`](/docs/reference/ecs/ecs-base#field-tags) and [`labels`](/docs/reference/ecs/ecs-base#field-labels) fields add simple metadata as `keyword` values.
  </definition>
</definitions>


## Host

In ECS, the `host` is the computing instance where the event happened. A `host` can be a physical device, virtual machine, container, or cloud instance.
The [`host.*`](https://www.elastic.co/docs/reference/ecs/ecs-host) field set contains common attributes for different computing instances. Certain host types have more fields to capture specific details, like `cloud.*` or `container.*`.

## Agent and observer

An agent is software that collects, observes, measures, or detects the event. The [`agent.*`](https://www.elastic.co/docs/reference/ecs/ecs-agent) fields capture details about which agent entity captured the event, including the agent’s version. Examples of agents are Beats and Elastic Agent.
An `observer` is an external monitoring or intermediary device, like a firewall, APM server, or web proxy. These devices monitor and detect network, security, application events. Capture the details for these device types in the [`observer.*`](https://www.elastic.co/docs/reference/ecs/ecs-observer) field set.

## Timestamps

ECS requires the `@timestamp` field on every event. Some events also contain extra timestamps to capture.
<definitions>
  <definition term="@timestamp">
    All events must populate [`@timestamp`](/docs/reference/ecs/ecs-base#field-timestamp) with when the event originated.
  </definition>
  <definition term="event.created">
    The timestamp of when an agent or pipeline saw the event.
  </definition>
  <definition term="event.ingested">
    The timestamp of when an event arrived in the central data store, like Elasticsearch.
  </definition>
</definitions>

These three timestamps should typically follow a chronological order:
```sh
@timestamp < event.created < event.ingested
```

<definitions>
  <definition term="event.start">
    This timestamp marks the beginning of the event activity. For example, in a network session, [`event.start`](/docs/reference/ecs/ecs-event#field-event-start) is the timestamp of the first observed packet in the flow.
  </definition>
  <definition term="event.end">
    This timestamp marks the end of the activity. In a network flow, [`event.end`](/docs/reference/ecs/ecs-event#field-event-end) is the timestamp of the last observed packet in the flow.
  </definition>
  <definition term="event.duration">
    The difference of `event.end` and `event.start`:
  </definition>
</definitions>

```sh
event.duration = event.end - event.start
```


## Origin

Specific `event.*` fields exist to capture where an event originated.
<definitions>
  <definition term="event.provider">
    Contains the name of the software or operating subsystem that generated the event.
  </definition>
  <definition term="event.module">
    If the ingest agent or pipeline has a concept of modules or plugins, populate [`event.module`](/docs/reference/ecs/ecs-event#field-event-module) with the module or plugin name.
  </definition>
  <definition term="event.dataset">
    Used to define different types of logs or metrics from an event source. The recommended convention is `<moduleName>.<datasetName>`. For Apache web server access logs, the [`event.dataset`](/docs/reference/ecs/ecs-event#field-event-dataset) value will be `apache.access`.
  </definition>
</definitions>


## Categorization

The event categorization fields group similar events using allowed values for four fields:
- `event.kind`
- `event.category`
- `event.type`
- `event.outcome`

[Using the Categorization Fields](https://www.elastic.co/docs/reference/ecs/ecs-using-categorization-fields) covers more details on using these four fields together to categorize events.

## Enriching events

A monitoring agent or ingest pipeline can add more details to the original event. ECS has many fields to hold these enrichment details.

## Lookups

<definitions>
  <definition term="GeoIP">
    Add information about the geographical location of an IPv4 or IPv6 address. Often used to populate the `geo.*` fields nested under network transaction fields like `source.*`, `destination.*`, `client.*`, and `server.*`.
  </definition>
</definitions>

```json
{
  "source": {
    "address": "8.8.8.8",
    "ip": "8.8.8.8",
    "geo": {
      "continent_name": "North America",
      "country_name": "United States",
      "country_iso_code": "US",
      "location": { "lat": 37.751, "lon": -97.822 }
    }
  }
}
```

<definitions>
  <definition term="Autonomous system number">
    Autonomous System Number (ASN) database lookups determine the ASN associated with an IP address.
  </definition>
</definitions>


## Parsing

<definitions>
  <definition term="User-agent">
    Break the user-agent into individual fields.
  </definition>
</definitions>

```json
{
  "user_agent": {
    "user_agent": {
      "name": "Chrome",
      "original": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36",
      "version": "51.0.2704.103",
      "os": {
        "name": "Mac OS X",
        "version": "10.10.5",
        "full": "Mac OS X 10.10.5",
        "platform": "darwin",
        "type": "macos"
      },
      "device" : {
        "name" : "Mac"
      }
    }
  }
}
```

<definitions>
  <definition term="URL">
    A URL can also break down into its discrete parts.
  </definition>
</definitions>

```json
{
  "original" : "http://myusername:mypassword@www.example.com:80/foo.gif?key1=val1&key2=val2#fragment",
  "url" : {
    "path" : "/foo.gif",
    "fragment" : "fragment",
    "extension" : "gif",
    "password" : "mypassword",
    "original" : "http://myusername:mypassword@www.example.com:80/foo.gif?key1=val1&key2=val2#fragment",
    "scheme" : "http",
    "port" : 80,
    "user_info" : "myusername:mypassword",
    "domain" : "www.example.com",
    "query" : "key1=val1&key2=val2",
    "username" : "myusername"
  }
}
```

<definitions>
  <definition term="Domain names">
    Extract the registered domain (also known as the effective top-level domain plus one), sub-domain, and effective top-level domain from a fully-qualified domain name (FQDN).
  </definition>
</definitions>

```json
{
  "fqdn": "www.example.ac.uk",
  "url": {
    "subdomain": "www",
    "registered_domain": "example.ac.uk",
    "top_level_domain": "ac.uk",
    "domain": "www.example.ac.uk"
}
```


## Related fields

Many events have similar content populating different fields: IP addresses, file hashes, hostnames. Pivot between these events using the [`related.*`](https://www.elastic.co/docs/reference/ecs/ecs-related) fields.
For example, IP addresses found under the `host.*`, `source.*`, `destination.*`, `client.*`, and `server.*` fields sets and the `network.forwarded_ip` field. By adding all IP addresses in an event to the `related.ip` field, there is now a single field to search for a given IP regardless of what field it appeared:
```sh
related.ip: ["10.42.42.42"]
```