﻿---
title: PE Header fields
description: These fields contain Windows Portable Executable (PE) metadata. The pe fields are expected to be nested at: dll.pe, file.pe, process.pe. Note also that...
url: https://www.elastic.co/docs/reference/ecs/ecs-pe
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# PE Header fields
These fields contain Windows Portable Executable (PE) metadata.

## PE Header field details


| Field                                                                     | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Level    |
|---------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [pe.architecture](#field-pe-architecture)                                 | CPU architecture target for the file.type: keywordexample: `x64`                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [pe.company](#field-pe-company)                                           | Internal company name of the file, provided at compile-time.type: keywordexample: `Microsoft Corporation`                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [pe.description](#field-pe-description)                                   | Internal description of the file, provided at compile-time.type: keywordexample: `Paint`                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [pe.file_version](#field-pe-file-version)                                 | Internal version of the file, provided at compile-time.type: keywordexample: `6.3.9600.17415`                                                                                                                                                                                                                                                                                                                                                                                                                      | extended |
| [pe.go_import_hash](#field-pe-go-import-hash)                             | A hash of the Go language imports in a PE file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.The algorithm used to calculate the Go symbol hash and a reference implementation are available here: [https://github.com/elastic/toutoumomoma](https://github.com/elastic/toutoumomoma)type: keywordexample: `10bddcb4cee42080f76c88d9ff964491` | extended |
| [pe.go_imports](#field-pe-go-imports)                                     | List of imported Go language element names and types.type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [pe.go_imports_names_entropy](#field-pe-go-imports-names-entropy)         | Shannon entropy calculation from the list of Go imports.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [pe.go_imports_names_var_entropy](#field-pe-go-imports-names-var-entropy) | Variance for Shannon entropy calculation from the list of Go imports.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [pe.go_stripped](#field-pe-go-stripped)                                   | Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.type: boolean                                                                                                                                                                                                                                                                                                                                                                | extended |
| [pe.imphash](#field-pe-imphash)                                           | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.Learn more at [https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html](https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html).type: keywordexample: `0c6803c4e922103c4dca5963aad36ddf`                  | extended |
| [pe.import_hash](#field-pe-import-hash)                                   | A hash of the imports in a PE file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.This is a synonym for imphash.type: keywordexample: `d41d8cd98f00b204e9800998ecf8427e`                                                                                                                                                                                                          | extended |
| [pe.imports](#field-pe-imports)                                           | List of imported element names and types.type: flattenedNote: This field should contain an array of values.                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [pe.imports_names_entropy](#field-pe-imports-names-entropy)               | Shannon entropy calculation from the list of imported element names and types.type: long                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [pe.imports_names_var_entropy](#field-pe-imports-names-var-entropy)       | Variance for Shannon entropy calculation from the list of imported element names and types.type: long                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [pe.original_file_name](#field-pe-original-file-name)                     | Internal name of the file, provided at compile-time.type: keywordexample: `MSPAINT.EXE`                                                                                                                                                                                                                                                                                                                                                                                                                            | extended |
| [pe.pehash](#field-pe-pehash)                                             | A hash of the PE header and data from one or more PE sections. An pehash can be used to cluster files by transforming structural information about a file into a hash value.Learn more at [https://www.usenix.org/legacy/events/leet09/tech/full_papers/wicherski/wicherski_html/index.html](https://www.usenix.org/legacy/events/leet09/tech/full_papers/wicherski/wicherski_html/index.html).type: keywordexample: `73ff189b63cd6be375a7ff25179a38d347651975`                                                    | extended |
| [pe.product](#field-pe-product)                                           | Internal product name of the file, provided at compile-time.type: keywordexample: `Microsoft® Windows® Operating System`                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [pe.sections](#field-pe-sections)                                         | An array containing an object for each section of the PE file.The keys that should be present in these objects are defined by sub-fields underneath `pe.sections.*`.type: nestedNote: This field should contain an array of values.                                                                                                                                                                                                                                                                                | extended |
| [pe.sections.entropy](#field-pe-sections-entropy)                         | Shannon entropy calculation from the section.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                            | extended |
| [pe.sections.name](#field-pe-sections-name)                               | PE Section List name.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [pe.sections.physical_size](#field-pe-sections-physical-size)             | PE Section List physical size.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [pe.sections.var_entropy](#field-pe-sections-var-entropy)                 | Variance for Shannon entropy calculation from the section.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [pe.sections.virtual_size](#field-pe-sections-virtual-size)               | PE Section List virtual size. This is always the same as `physical_size`.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |


## Field reuse

The `pe` fields are expected to be nested at:
- `dll.pe`
- `file.pe`
- `process.pe`

Note also that the `pe` fields are not expected to be used directly at the root of the events.