﻿---
title: Package fields
description: These fields contain information about an installed software package. It contains general information about a package, such as name, version or size...
url: https://www.elastic.co/docs/reference/ecs/ecs-package
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Package fields
These fields contain information about an installed software package. It contains general information about a package, such as name, version or size. It also contains installation details, such as time or location.

## Package field details


| Field                                                 | Description                                                                                                                                                                                                                            | Level    |
|-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [package.architecture](#field-package-architecture)   | Package architecture.type: keywordexample: `x86_64`                                                                                                                                                                                    | extended |
| [package.build_version](#field-package-build-version) | Additional information about the build version of the installed package.For example use the commit SHA of a non-released package.type: keywordexample: `36f4f7e89dd61b0988b12ee000b98966867710cd`                                      | extended |
| [package.checksum](#field-package-checksum)           | Checksum of the installed package for verification.type: keywordexample: `68b329da9893e34099c7d8ad5cb9c940`                                                                                                                            | extended |
| [package.description](#field-package-description)     | Description of the package.type: keywordexample: `Open source programming language to build simple/reliable/efficient software.`                                                                                                       | extended |
| [package.install_scope](#field-package-install-scope) | Indicating how the package was installed, e.g. user-local, global.type: keywordexample: `global`                                                                                                                                       | extended |
| [package.installed](#field-package-installed)         | Time when package was installed.type: date                                                                                                                                                                                             | extended |
| [package.license](#field-package-license)             | License under which the package was released.Use a short name, e.g. the license identifier from SPDX License List where possible ([https://spdx.org/licenses/](https://spdx.org/licenses/)).type: keywordexample: `Apache License 2.0` | extended |
| [package.name](#field-package-name)                   | Package nametype: keywordexample: `go`                                                                                                                                                                                                 | extended |
| [package.path](#field-package-path)                   | Path where the package is installed.type: keywordexample: `/usr/local/Cellar/go/1.12.9/`                                                                                                                                               | extended |
| [package.reference](#field-package-reference)         | Home page or reference URL of the software in this package, if available.type: keywordexample: `https://golang.org`                                                                                                                    | extended |
| [package.size](#field-package-size)                   | Package size in bytes.type: longexample: `62231`                                                                                                                                                                                       | extended |
| [package.type](#field-package-type)                   | Type of package.This should contain the package file type, rather than the package manager name. Examples: rpm, dpkg, brew, npm, gem, nupkg, jar.type: keywordexample: `rpm`                                                           | extended |
| [package.version](#field-package-version)             | Package versiontype: keywordexample: `1.12.9`                                                                                                                                                                                          | extended |