﻿---
title: OTel Alignment Overview
description: The following table summarizes the alignment status by namespaces between ECS in version 9.3.0 and OpenTelemetry semantic conventions in version 1.38.0...
url: https://www.elastic.co/docs/reference/ecs/ecs-otel-alignment-overview
products:
  - Elastic Common Schema (ECS)
---

# OTel Alignment Overview
The following table summarizes the alignment status by namespaces between ECS in version `9.3.0` and OpenTelemetry semantic conventions in version `1.38.0`.

|                                                    |                                                                    |                                                                                    |                                                                           |                                                                                     |                                                                               |                                                                                 |                                                                             |                                                                         |                                                                        |
|----------------------------------------------------|--------------------------------------------------------------------|------------------------------------------------------------------------------------|---------------------------------------------------------------------------|-------------------------------------------------------------------------------------|-------------------------------------------------------------------------------|---------------------------------------------------------------------------------|-----------------------------------------------------------------------------|-------------------------------------------------------------------------|------------------------------------------------------------------------|
|                                                    | Number of Fields / Attributes                                      |                                                                                    |                                                                           |                                                                                     |                                                                               |                                                                                 |                                                                             |                                                                         |                                                                        |
| Namespace                                          | ECS                                                                | OTel                                                                               | ![relation](https://img.shields.io/badge/match-93c93e?style=flat "match") | ![relation](https://img.shields.io/badge/equivalent-1ba9f5?style=flat "equivalent") | ![relation](https://img.shields.io/badge/related-efc20d?style=flat "related") | ![relation](https://img.shields.io/badge/conflict-910000?style=flat "conflict") | ![relation](https://img.shields.io/badge/metric-cb00cb?style=flat "metric") | ![relation](https://img.shields.io/badge/OTLP-ffdcb2?style=flat "OTLP") | ![relation](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat "na") |
| Agent                                              | [6](https://www.elastic.co/docs/reference/ecs/ecs-agent)           | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Android                                            | ·                                                                  | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/android)       | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Application                                        | ·                                                                  | [11](https://opentelemetry.io/docs/specs/semconv/attributes-registry/app)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Artifact                                           | ·                                                                  | [7](https://opentelemetry.io/docs/specs/semconv/attributes-registry/artifact)      | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Autonomous System                                  | [2](https://www.elastic.co/docs/reference/ecs/ecs-as)              | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| ASP.NET Core                                       | ·                                                                  | [23](https://opentelemetry.io/docs/specs/semconv/attributes-registry/aspnetcore)   | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| General AWS                                        | ·                                                                  | [52](https://opentelemetry.io/docs/specs/semconv/attributes-registry/aws)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Azure Client Library                               | ·                                                                  | [9](https://opentelemetry.io/docs/specs/semconv/attributes-registry/azure)         | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Base                                               | [4](https://www.elastic.co/docs/reference/ecs/ecs-base)            | ·                                                                                  | ·                                                                         | ·                                                                                   | 2                                                                             | ·                                                                               | ·                                                                           | 4                                                                       | ·                                                                      |
| Browser                                            | ·                                                                  | [4](https://opentelemetry.io/docs/specs/semconv/attributes-registry/browser)       | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Cassandra                                          | ·                                                                  | [6](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cassandra)     | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| CI/CD Pipeline                                     | ·                                                                  | [16](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cicd)         | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Client                                             | [12](https://www.elastic.co/docs/reference/ecs/ecs-client)         | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/client)        | 2                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Cloud                                              | [11](https://www.elastic.co/docs/reference/ecs/ecs-cloud)          | [6](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud)         | 4                                                                         | 1                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| CloudEvents                                        | ·                                                                  | [5](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloudevents)   | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| CloudFoundry                                       | ·                                                                  | [11](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloudfoundry) | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Code                                               | ·                                                                  | [5](https://opentelemetry.io/docs/specs/semconv/attributes-registry/code)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Code Signature                                     | [11](https://www.elastic.co/docs/reference/ecs/ecs-code_signature) | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Container                                          | [14](https://www.elastic.co/docs/reference/ecs/ecs-container)      | [15](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container)    | 3                                                                         | 3                                                                                   | 1                                                                             | ·                                                                               | 2                                                                           | ·                                                                       | ·                                                                      |
| CPU                                                | ·                                                                  | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cpu)           | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| CPython attributes                                 | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cpython)       | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Data Stream                                        | [3](https://www.elastic.co/docs/reference/ecs/ecs-data_stream)     | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | 3                                                                      |
| General Database                                   | ·                                                                  | [14](https://opentelemetry.io/docs/specs/semconv/attributes-registry/db)           | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Deployment                                         | ·                                                                  | [4](https://opentelemetry.io/docs/specs/semconv/attributes-registry/deployment)    | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Destination                                        | [12](https://www.elastic.co/docs/reference/ecs/ecs-destination)    | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/destination)   | 2                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Device                                             | [10](https://www.elastic.co/docs/reference/ecs/ecs-device)         | [4](https://opentelemetry.io/docs/specs/semconv/attributes-registry/device)        | 4                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Disk                                               | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/disk)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| DLL                                                | [4](https://www.elastic.co/docs/reference/ecs/ecs-dll)             | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| DNS                                                | [18](https://www.elastic.co/docs/reference/ecs/ecs-dns)            | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/dns)           | 1                                                                         | ·                                                                                   | 1                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| .NET                                               | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/dotnet)        | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| ECS                                                | [1](https://www.elastic.co/docs/reference/ecs/ecs-ecs)             | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | 1                                                                      |
| Elasticsearch                                      | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/elasticsearch) | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| ELF Header                                         | [38](https://www.elastic.co/docs/reference/ecs/ecs-elf)            | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Email                                              | [19](https://www.elastic.co/docs/reference/ecs/ecs-email)          | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| End User                                           | ·                                                                  | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/enduser)       | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Entity                                             | [13](https://www.elastic.co/docs/reference/ecs/ecs-entity)         | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Error                                              | [5](https://www.elastic.co/docs/reference/ecs/ecs-error)           | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/error)         | 1                                                                         | 2                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Event                                              | [26](https://www.elastic.co/docs/reference/ecs/ecs-event)          | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Exception                                          | ·                                                                  | [3](https://opentelemetry.io/docs/specs/semconv/attributes-registry/exception)     | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| FaaS                                               | [7](https://www.elastic.co/docs/reference/ecs/ecs-faas)            | [16](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas)         | 3                                                                         | 2                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Feature Flag                                       | ·                                                                  | [8](https://opentelemetry.io/docs/specs/semconv/attributes-registry/feature-flag)  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| File                                               | [24](https://www.elastic.co/docs/reference/ecs/ecs-file)           | [18](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file)         | 11                                                                        | 7                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| GCP Client                                         | ·                                                                  | [23](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gcp)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Gen AI                                             | [26](https://www.elastic.co/docs/reference/ecs/ecs-gen_ai)         | [40](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai)       | 25                                                                        | 1                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Geo                                                | [11](https://www.elastic.co/docs/reference/ecs/ecs-geo)            | [7](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo)           | 1                                                                         | 4                                                                                   | 2                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Go                                                 | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/go)            | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| GraphQL                                            | ·                                                                  | [3](https://opentelemetry.io/docs/specs/semconv/attributes-registry/graphql)       | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Group                                              | [3](https://www.elastic.co/docs/reference/ecs/ecs-group)           | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Hash                                               | [8](https://www.elastic.co/docs/reference/ecs/ecs-hash)            | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Heroku                                             | ·                                                                  | [3](https://opentelemetry.io/docs/specs/semconv/attributes-registry/heroku)        | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Host                                               | [18](https://www.elastic.co/docs/reference/ecs/ecs-host)           | [15](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host)         | 5                                                                         | 1                                                                                   | ·                                                                             | ·                                                                               | 8                                                                           | ·                                                                       | ·                                                                      |
| HTTP                                               | [13](https://www.elastic.co/docs/reference/ecs/ecs-http)           | [12](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http)         | 1                                                                         | 5                                                                                   | 2                                                                             | 1                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Hardware                                           | ·                                                                  | [27](https://opentelemetry.io/docs/specs/semconv/attributes-registry/hw)           | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Interface                                          | [3](https://www.elastic.co/docs/reference/ecs/ecs-interface)       | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| iOS                                                | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/ios)           | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Java Virtual Machine (JVM)                         | ·                                                                  | [8](https://opentelemetry.io/docs/specs/semconv/attributes-registry/jvm)           | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Kubernetes                                         | ·                                                                  | [62](https://opentelemetry.io/docs/specs/semconv/attributes-registry/k8s)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Linux Memory                                       | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/linux)         | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Log                                                | [18](https://www.elastic.co/docs/reference/ecs/ecs-log)            | [7](https://opentelemetry.io/docs/specs/semconv/attributes-registry/log)           | 1                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | 1                                                                       | ·                                                                      |
| Mach-O Header                                      | [16](https://www.elastic.co/docs/reference/ecs/ecs-macho)          | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Mainframe LPAR attributes                          | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/mainframe)     | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| General Messaging                                  | ·                                                                  | [37](https://opentelemetry.io/docs/specs/semconv/attributes-registry/messaging)    | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Network                                            | [12](https://www.elastic.co/docs/reference/ecs/ecs-network)        | [17](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network)      | 2                                                                         | 1                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| NFS                                                | ·                                                                  | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/nfs)           | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Node.js                                            | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/nodejs)        | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Observer                                           | [13](https://www.elastic.co/docs/reference/ecs/ecs-observer)       | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Open Container Initiative (OCI)                    | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/oci)           | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| ONC RPC (Sun RPC) attributes                       | ·                                                                  | [4](https://opentelemetry.io/docs/specs/semconv/attributes-registry/onc-rpc)       | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| OpenAI                                             | ·                                                                  | [3](https://opentelemetry.io/docs/specs/semconv/attributes-registry/openai)        | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Openshift                                          | ·                                                                  | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/openshift)     | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| OpenTracing                                        | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/opentracing)   | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Orchestrator                                       | [15](https://www.elastic.co/docs/reference/ecs/ecs-orchestrator)   | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Organization                                       | [2](https://www.elastic.co/docs/reference/ecs/ecs-organization)    | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Operating System                                   | [7](https://www.elastic.co/docs/reference/ecs/ecs-os)              | [5](https://opentelemetry.io/docs/specs/semconv/attributes-registry/os)            | 2                                                                         | 1                                                                                   | ·                                                                             | 1                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| OTel                                               | ·                                                                  | [9](https://opentelemetry.io/docs/specs/semconv/attributes-registry/otel)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Package                                            | [13](https://www.elastic.co/docs/reference/ecs/ecs-package)        | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| PE Header                                          | [23](https://www.elastic.co/docs/reference/ecs/ecs-pe)             | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Peer                                               | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/peer)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Pprof specific attributes for the Profiling signal | ·                                                                  | [6](https://opentelemetry.io/docs/specs/semconv/attributes-registry/pprof)         | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Process                                            | [34](https://www.elastic.co/docs/reference/ecs/ecs-process)        | [34](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process)      | 15                                                                        | 2                                                                                   | ·                                                                             | ·                                                                               | 1                                                                           | ·                                                                       | ·                                                                      |
| Profile Frame                                      | ·                                                                  | [1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/profile)       | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Registry                                           | [7](https://www.elastic.co/docs/reference/ecs/ecs-registry)        | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Related                                            | [4](https://www.elastic.co/docs/reference/ecs/ecs-related)         | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | 4                                                                      |
| Risk information                                   | [6](https://www.elastic.co/docs/reference/ecs/ecs-risk)            | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Remote Procedure Call (RPC)                        | ·                                                                  | [17](https://opentelemetry.io/docs/specs/semconv/attributes-registry/rpc)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Rule                                               | [10](https://www.elastic.co/docs/reference/ecs/ecs-rule)           | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Security Rule                                      | ·                                                                  | [8](https://opentelemetry.io/docs/specs/semconv/attributes-registry/security-rule) | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Server                                             | [12](https://www.elastic.co/docs/reference/ecs/ecs-server)         | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/server)        | 2                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Service                                            | [11](https://www.elastic.co/docs/reference/ecs/ecs-service)        | [4](https://opentelemetry.io/docs/specs/semconv/attributes-registry/service)       | 2                                                                         | 2                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Session                                            | ·                                                                  | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/session)       | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| SignalR                                            | ·                                                                  | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/signalr)       | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Source                                             | [12](https://www.elastic.co/docs/reference/ecs/ecs-source)         | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/source)        | 2                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| General System                                     | ·                                                                  | [9](https://opentelemetry.io/docs/specs/semconv/attributes-registry/system)        | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Telemetry                                          | ·                                                                  | [5](https://opentelemetry.io/docs/specs/semconv/attributes-registry/telemetry)     | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Test                                               | ·                                                                  | [4](https://opentelemetry.io/docs/specs/semconv/attributes-registry/test)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Thread                                             | ·                                                                  | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/thread)        | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| Threat                                             | [65](https://www.elastic.co/docs/reference/ecs/ecs-threat)         | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| TLS                                                | [29](https://www.elastic.co/docs/reference/ecs/ecs-tls)            | [28](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls)          | 26                                                                        | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Tracing                                            | [3](https://www.elastic.co/docs/reference/ecs/ecs-tracing)         | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | 2                                                                       | 1                                                                      |
| URL                                                | [14](https://www.elastic.co/docs/reference/ecs/ecs-url)            | [13](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url)          | 12                                                                        | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| User                                               | [7](https://www.elastic.co/docs/reference/ecs/ecs-user)            | [6](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user)          | 6                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| User agent                                         | [4](https://www.elastic.co/docs/reference/ecs/ecs-user_agent)      | [6](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user-agent)    | 3                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| V8 JS                                              | ·                                                                  | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/v8js)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| VCS Repository                                     | ·                                                                  | [16](https://opentelemetry.io/docs/specs/semconv/attributes-registry/vcs)          | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| VLAN                                               | [2](https://www.elastic.co/docs/reference/ecs/ecs-vlan)            | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Volume                                             | [16](https://www.elastic.co/docs/reference/ecs/ecs-volume)         | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Vulnerability                                      | [13](https://www.elastic.co/docs/reference/ecs/ecs-vulnerability)  | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| Web Engine                                         | ·                                                                  | [3](https://opentelemetry.io/docs/specs/semconv/attributes-registry/webengine)     | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |
| x509 Certificate                                   | [24](https://www.elastic.co/docs/reference/ecs/ecs-x509)           | ·                                                                                  | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       | ·                                                                      |
| z/OS attributes                                    | ·                                                                  | [2](https://opentelemetry.io/docs/specs/semconv/attributes-registry/zos)           | ·                                                                         | ·                                                                                   | ·                                                                             | ·                                                                               | ·                                                                           | ·                                                                       |                                                                        |