﻿---
title: Field & Attributes Alignment
description: The following table gives an overview of mappings between individual ECS fields (in ECS version 9.3.0) and corresponding OTel semantic convention attributes...
url: https://www.elastic.co/docs/reference/ecs/ecs-otel-alignment-details
products:
  - Elastic Common Schema (ECS)
---

# Field & Attributes Alignment
The following table gives an overview of mappings between individual ECS fields (in ECS version `9.3.0`) and corresponding OTel semantic convention attributes (in SemConv version `1.38.0`).

| ECS Field                                                                                                 | Relation                                                                                                                                     | OTel Semantic Conventions Attribute                                                                                                                                                                                                                                                                                                                                                                         | Stability                                                        |
|-----------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------|
| **Base Fields**                                                                                           |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [@timestamp](/docs/reference/ecs/ecs-base#field-timestamp)                                                | [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)             | [time_unix_nano](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+time_unix_nano+%22&type=code)                                                                                                                                                                                                                                                                                  | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [@timestamp](/docs/reference/ecs/ecs-base#field-timestamp)                                                | [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)             | [observed_time_unix_nano](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+observed_time_unix_nano+%22&type=code)                                                                                                                                                                                                                                                                | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [@timestamp](/docs/reference/ecs/ecs-base#field-timestamp)                                                | [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)             | [start_time_unix_nano](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+start_time_unix_nano+%22&type=code)Note: On logs, events and metrics, `time_unix_nano` defines the time of the event. For logs, `observed_time_unix_nano` defines the time when the event was observed by the collection system. On spans, `start_time_unix_nano` represents the start time of the span. | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [labels](/docs/reference/ecs/ecs-base#field-labels)                                                       | [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)       | [k8s.pod.label](https://opentelemetry.io/docs/specs/semconv/attributes-registry/k8s/#k8s-pod-label)                                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [labels](/docs/reference/ecs/ecs-base#field-labels)                                                       | [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)       | [container.label](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-label)                                                                                                                                                                                                                                                                                               | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [message](/docs/reference/ecs/ecs-base#field-message)                                                     | [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)             | [body](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+body+%22&type=code)Note: The `body` in OTLP is of type `Any` and can be either an unstructured log message or a structured event.                                                                                                                                                                                        | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| **Client Fields**                                                                                         |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [client.address](/docs/reference/ecs/ecs-client#field-client-address)                                     | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [client.address](https://opentelemetry.io/docs/specs/semconv/attributes-registry/client/#client-address)                                                                                                                                                                                                                                                                                                    | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [client.port](/docs/reference/ecs/ecs-client#field-client-port)                                           | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [client.port](https://opentelemetry.io/docs/specs/semconv/attributes-registry/client/#client-port)                                                                                                                                                                                                                                                                                                          | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| **Cloud Fields**                                                                                          |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [cloud.account.id](/docs/reference/ecs/ecs-cloud#field-cloud-account-id)                                  | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [cloud.account.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/#cloud-account-id)                                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [cloud.availability_zone](/docs/reference/ecs/ecs-cloud#field-cloud-availability-zone)                    | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [cloud.availability_zone](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/#cloud-availability-zone)                                                                                                                                                                                                                                                                                   | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [cloud.provider](/docs/reference/ecs/ecs-cloud#field-cloud-provider)                                      | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [cloud.provider](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/#cloud-provider)                                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [cloud.region](/docs/reference/ecs/ecs-cloud#field-cloud-region)                                          | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [cloud.region](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/#cloud-region)                                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [cloud.service.name](/docs/reference/ecs/ecs-cloud#field-cloud-service-name)                              | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [cloud.platform](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/#cloud-platform)                                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **Container Fields**                                                                                      |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [container.cpu.usage](/docs/reference/ecs/ecs-container#field-container-cpu-usage)                        | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [container.cpu.usage](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.container.cpu.usage+--%3E%22&type=code)                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [container.id](/docs/reference/ecs/ecs-container#field-container-id)                                      | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [container.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-id)                                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [container.image.hash.all](/docs/reference/ecs/ecs-container#field-container-image-hash-all)              | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [container.image.repo_digests](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-image-repo-digests)                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [container.image.name](/docs/reference/ecs/ecs-container#field-container-image-name)                      | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [container.image.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-image-name)                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [container.image.tag](/docs/reference/ecs/ecs-container#field-container-image-tag)                        | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [container.image.tags](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-image-tags)                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [container.labels](/docs/reference/ecs/ecs-container#field-container-labels)                              | [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)       | [container.label](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-label)                                                                                                                                                                                                                                                                                               | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [container.memory.usage](/docs/reference/ecs/ecs-container#field-container-memory-usage)                  | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [container.memory.usage](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.container.memory.usage+--%3E%22&type=code)                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [container.name](/docs/reference/ecs/ecs-container#field-container-name)                                  | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [container.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-name)                                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [container.runtime](/docs/reference/ecs/ecs-container#field-container-runtime)                            | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [container.runtime.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-runtime-name)                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **Data Stream Fields**                                                                                    |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [data_stream.dataset](/docs/reference/ecs/ecs-data_stream#field-data-stream-dataset)                      | [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)  | Not applicable.                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [data_stream.namespace](/docs/reference/ecs/ecs-data_stream#field-data-stream-namespace)                  | [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)  | Not applicable.                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [data_stream.type](/docs/reference/ecs/ecs-data_stream#field-data-stream-type)                            | [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)  | Not applicable.                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| **Destination Fields**                                                                                    |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [destination.address](/docs/reference/ecs/ecs-destination#field-destination-address)                      | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [destination.address](https://opentelemetry.io/docs/specs/semconv/attributes-registry/destination/#destination-address)                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [destination.port](/docs/reference/ecs/ecs-destination#field-destination-port)                            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [destination.port](https://opentelemetry.io/docs/specs/semconv/attributes-registry/destination/#destination-port)                                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **Device Fields**                                                                                         |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [device.id](/docs/reference/ecs/ecs-device#field-device-id)                                               | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [device.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/device/#device-id)                                                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [device.manufacturer](/docs/reference/ecs/ecs-device#field-device-manufacturer)                           | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [device.manufacturer](https://opentelemetry.io/docs/specs/semconv/attributes-registry/device/#device-manufacturer)                                                                                                                                                                                                                                                                                          | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [device.model.identifier](/docs/reference/ecs/ecs-device#field-device-model-identifier)                   | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [device.model.identifier](https://opentelemetry.io/docs/specs/semconv/attributes-registry/device/#device-model-identifier)                                                                                                                                                                                                                                                                                  | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [device.model.name](/docs/reference/ecs/ecs-device#field-device-model-name)                               | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [device.model.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/device/#device-model-name)                                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **DNS Fields**                                                                                            |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [dns.answers](/docs/reference/ecs/ecs-dns#field-dns-answers)                                              | [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)       | [dns.answers](https://opentelemetry.io/docs/specs/semconv/attributes-registry/dns/#dns-answers)                                                                                                                                                                                                                                                                                                             | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [dns.question.name](/docs/reference/ecs/ecs-dns#field-dns-question-name)                                  | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [dns.question.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/dns/#dns-question-name)                                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **ECS Fields**                                                                                            |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [ecs.version](/docs/reference/ecs/ecs-ecs#field-ecs-version)                                              | [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)  | Not applicable.                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| **Error Fields**                                                                                          |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [error.message](/docs/reference/ecs/ecs-error#field-error-message)                                        | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [exception.message](https://opentelemetry.io/docs/specs/semconv/attributes-registry/exception/#exception-message)                                                                                                                                                                                                                                                                                           | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [error.stack_trace](/docs/reference/ecs/ecs-error#field-error-stack-trace)                                | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [exception.stacktrace](https://opentelemetry.io/docs/specs/semconv/attributes-registry/exception/#exception-stacktrace)                                                                                                                                                                                                                                                                                     | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [error.type](/docs/reference/ecs/ecs-error#field-error-type)                                              | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [error.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/error/#error-type)                                                                                                                                                                                                                                                                                                             | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| **FaaS Fields**                                                                                           |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [faas.coldstart](/docs/reference/ecs/ecs-faas#field-faas-coldstart)                                       | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [faas.coldstart](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas/#faas-coldstart)                                                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [faas.execution](/docs/reference/ecs/ecs-faas#field-faas-execution)                                       | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [faas.invocation_id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas/#faas-invocation-id)                                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [faas.name](/docs/reference/ecs/ecs-faas#field-faas-name)                                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [faas.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas/#faas-name)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [faas.trigger.type](/docs/reference/ecs/ecs-faas#field-faas-trigger-type)                                 | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [faas.trigger](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas/#faas-trigger)                                                                                                                                                                                                                                                                                                          | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [faas.version](/docs/reference/ecs/ecs-faas#field-faas-version)                                           | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [faas.version](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas/#faas-version)                                                                                                                                                                                                                                                                                                          | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **File Fields**                                                                                           |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [file.accessed](/docs/reference/ecs/ecs-file#field-file-accessed)                                         | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.accessed](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-accessed)                                                                                                                                                                                                                                                                                                        | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.attributes](/docs/reference/ecs/ecs-file#field-file-attributes)                                     | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.attributes](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-attributes)                                                                                                                                                                                                                                                                                                    | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.created](/docs/reference/ecs/ecs-file#field-file-created)                                           | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.created](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-created)                                                                                                                                                                                                                                                                                                          | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.ctime](/docs/reference/ecs/ecs-file#field-file-ctime)                                               | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [file.changed](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-changed)                                                                                                                                                                                                                                                                                                          | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.directory](/docs/reference/ecs/ecs-file#field-file-directory)                                       | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.directory](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-directory)                                                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.extension](/docs/reference/ecs/ecs-file#field-file-extension)                                       | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.extension](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-extension)                                                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.fork_name](/docs/reference/ecs/ecs-file#field-file-fork-name)                                       | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.fork_name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-fork-name)                                                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.gid](/docs/reference/ecs/ecs-file#field-file-gid)                                                   | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [file.group.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-group-id)                                                                                                                                                                                                                                                                                                        | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.group](/docs/reference/ecs/ecs-file#field-file-group)                                               | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [file.group.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-group-name)                                                                                                                                                                                                                                                                                                    | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.inode](/docs/reference/ecs/ecs-file#field-file-inode)                                               | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.inode](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-inode)                                                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.mode](/docs/reference/ecs/ecs-file#field-file-mode)                                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.mode](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-mode)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.mtime](/docs/reference/ecs/ecs-file#field-file-mtime)                                               | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [file.modified](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-modified)                                                                                                                                                                                                                                                                                                        | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.name](/docs/reference/ecs/ecs-file#field-file-name)                                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-name)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.owner](/docs/reference/ecs/ecs-file#field-file-owner)                                               | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [file.owner.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-owner-name)                                                                                                                                                                                                                                                                                                    | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.path](/docs/reference/ecs/ecs-file#field-file-path)                                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.path](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-path)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.size](/docs/reference/ecs/ecs-file#field-file-size)                                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [file.size](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-size)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.target_path](/docs/reference/ecs/ecs-file#field-file-target-path)                                   | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [file.symbolic_link.target_path](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-symbolic-link-target-path)                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [file.uid](/docs/reference/ecs/ecs-file#field-file-uid)                                                   | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [file.owner.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-owner-id)                                                                                                                                                                                                                                                                                                        | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **Gen AI Fields**                                                                                         |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [gen_ai.agent.description](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-agent-description)                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.agent.description](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-agent-description)                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.agent.id](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-agent-id)                                   | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.agent.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-agent-id)                                                                                                                                                                                                                                                                                                  | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.agent.name](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-agent-name)                               | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.agent.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-agent-name)                                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.operation.name](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-operation-name)                       | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.operation.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-operation-name)                                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.output.type](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-output-type)                             | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.output.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-output-type)                                                                                                                                                                                                                                                                                            | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.choice.count](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-choice-count)           | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.choice.count](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-choice-count)                                                                                                                                                                                                                                                                          | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.encoding_formats](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-encoding-formats)   | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.encoding_formats](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-encoding-formats)                                                                                                                                                                                                                                                                  | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.frequency_penalty](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-frequency-penalty) | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.frequency_penalty](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-frequency-penalty)                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.max_tokens](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-max-tokens)               | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.max_tokens](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-max-tokens)                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.model](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-model)                         | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.model](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-model)                                                                                                                                                                                                                                                                                        | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.presence_penalty](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-presence-penalty)   | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.presence_penalty](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-presence-penalty)                                                                                                                                                                                                                                                                  | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.seed](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-seed)                           | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.seed](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-seed)                                                                                                                                                                                                                                                                                          | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.stop_sequences](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-stop-sequences)       | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.stop_sequences](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-stop-sequences)                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.temperature](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-temperature)             | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.temperature](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-temperature)                                                                                                                                                                                                                                                                            | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.top_k](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-top-k)                         | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.top_k](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-top-k)                                                                                                                                                                                                                                                                                        | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.request.top_p](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-request-top-p)                         | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.request.top_p](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-top-p)                                                                                                                                                                                                                                                                                        | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.response.finish_reasons](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-response-finish-reasons)     | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.response.finish_reasons](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-response-finish-reasons)                                                                                                                                                                                                                                                                    | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.response.id](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-response-id)                             | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.response.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-response-id)                                                                                                                                                                                                                                                                                            | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.response.model](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-response-model)                       | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.response.model](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-response-model)                                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.system](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-system)                                       | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [gen_ai.provider.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-provider-name)                                                                                                                                                                                                                                                                                        | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.token.type](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-token-type)                               | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.token.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-token-type)                                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.tool.call.id](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-tool-call-id)                           | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.tool.call.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-tool-call-id)                                                                                                                                                                                                                                                                                          | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.tool.name](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-tool-name)                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.tool.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-tool-name)                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.tool.type](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-tool-type)                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.tool.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-tool-type)                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.usage.input_tokens](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-usage-input-tokens)               | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.usage.input_tokens](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-usage-input-tokens)                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [gen_ai.usage.output_tokens](/docs/reference/ecs/ecs-gen_ai#field-gen-ai-usage-output-tokens)             | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [gen_ai.usage.output_tokens](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-usage-output-tokens)                                                                                                                                                                                                                                                                            | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **Geo Fields**                                                                                            |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [geo.city_name](/docs/reference/ecs/ecs-geo#field-geo-city-name)                                          | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [geo.locality.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-locality-name)                                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [geo.continent_code](/docs/reference/ecs/ecs-geo#field-geo-continent-code)                                | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [geo.continent.code](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-continent-code)                                                                                                                                                                                                                                                                                               | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [geo.country_iso_code](/docs/reference/ecs/ecs-geo#field-geo-country-iso-code)                            | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [geo.country.iso_code](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-country-iso-code)                                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [geo.location](/docs/reference/ecs/ecs-geo#field-geo-location)                                            | [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)       | [geo.location.lat](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-location-lat)                                                                                                                                                                                                                                                                                                   | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [geo.location](/docs/reference/ecs/ecs-geo#field-geo-location)                                            | [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)       | [geo.location.lon](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-location-lon)                                                                                                                                                                                                                                                                                                   | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [geo.postal_code](/docs/reference/ecs/ecs-geo#field-geo-postal-code)                                      | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [geo.postal_code](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-postal-code)                                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [geo.region_iso_code](/docs/reference/ecs/ecs-geo#field-geo-region-iso-code)                              | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [geo.region.iso_code](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-region-iso-code)                                                                                                                                                                                                                                                                                             | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **Host Fields**                                                                                           |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [host.architecture](/docs/reference/ecs/ecs-host#field-host-architecture)                                 | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [host.arch](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-arch)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.cpu.usage](/docs/reference/ecs/ecs-host#field-host-cpu-usage)                                       | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [system.cpu.utilization](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.cpu.utilization+--%3E%22&type=code)                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.disk.read.bytes](/docs/reference/ecs/ecs-host#field-host-disk-read-bytes)                           | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [system.disk.io](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.disk.io+--%3E%22&type=code)                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.disk.write.bytes](/docs/reference/ecs/ecs-host#field-host-disk-write-bytes)                         | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [system.disk.io](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.disk.io+--%3E%22&type=code)                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.id](/docs/reference/ecs/ecs-host#field-host-id)                                                     | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [host.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-id)                                                                                                                                                                                                                                                                                                                    | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.ip](/docs/reference/ecs/ecs-host#field-host-ip)                                                     | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [host.ip](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-ip)                                                                                                                                                                                                                                                                                                                    | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.mac](/docs/reference/ecs/ecs-host#field-host-mac)                                                   | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [host.mac](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-mac)                                                                                                                                                                                                                                                                                                                  | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.name](/docs/reference/ecs/ecs-host#field-host-name)                                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [host.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-name)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.network.egress.bytes](/docs/reference/ecs/ecs-host#field-host-network-egress-bytes)                 | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [system.network.io](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.network.io+--%3E%22&type=code)                                                                                                                                                                                                                                               | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.network.egress.packets](/docs/reference/ecs/ecs-host#field-host-network-egress-packets)             | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [system.network.packet.count](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.network.packet.count+--%3E%22&type=code)                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.network.ingress.bytes](/docs/reference/ecs/ecs-host#field-host-network-ingress-bytes)               | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [system.network.io](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.network.io+--%3E%22&type=code)                                                                                                                                                                                                                                               | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.network.ingress.packets](/docs/reference/ecs/ecs-host#field-host-network-ingress-packets)           | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [system.network.packet.count](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.network.packet.count+--%3E%22&type=code)                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.type](/docs/reference/ecs/ecs-host#field-host-type)                                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [host.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-type)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [host.uptime](/docs/reference/ecs/ecs-host#field-host-uptime)                                             | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [system.uptime](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.uptime+--%3E%22&type=code)                                                                                                                                                                                                                                                       | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **HTTP Fields**                                                                                           |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [http.request.body.bytes](/docs/reference/ecs/ecs-http#field-http-request-body-bytes)                     | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [http.request.body.size](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-request-body-size)                                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [http.request.bytes](/docs/reference/ecs/ecs-http#field-http-request-bytes)                               | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [http.request.size](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-request-size)                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [http.request.method](/docs/reference/ecs/ecs-http#field-http-request-method)                             | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [http.request.method_original](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-request-method-original)                                                                                                                                                                                                                                                                          | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [http.request.method](/docs/reference/ecs/ecs-http#field-http-request-method)                             | [![conflict](https://img.shields.io/badge/conflict-910000?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)     | [http.request.method](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-request-method)Note: `http.request.method` in SemConv is the known, normalized, upper case value of the request method, other than the ECS' `http.request.method` that retains casing from the original event.                                                                                             | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [http.response.body.bytes](/docs/reference/ecs/ecs-http#field-http-response-body-bytes)                   | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [http.response.body.size](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-response-body-size)                                                                                                                                                                                                                                                                                    | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [http.response.bytes](/docs/reference/ecs/ecs-http#field-http-response-bytes)                             | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [http.response.size](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-response-size)                                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [http.response.status_code](/docs/reference/ecs/ecs-http#field-http-response-status-code)                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [http.response.status_code](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-response-status-code)                                                                                                                                                                                                                                                                                | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [http.version](/docs/reference/ecs/ecs-http#field-http-version)                                           | [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)       | [network.protocol.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network/#network-protocol-name)                                                                                                                                                                                                                                                                                     | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [http.version](/docs/reference/ecs/ecs-http#field-http-version)                                           | [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)       | [network.protocol.version](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network/#network-protocol-version)Note: In OTel SemConv, `network.protocol.version` specifies the HTTP version if the value of `network.protocol.name` is `http`.                                                                                                                                                | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| **Log Fields**                                                                                            |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [log.file.path](/docs/reference/ecs/ecs-log#field-log-file-path)                                          | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [log.file.path](https://opentelemetry.io/docs/specs/semconv/attributes-registry/log/#log-file-path)                                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [log.level](/docs/reference/ecs/ecs-log#field-log-level)                                                  | [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)             | [severity_text](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+severity_text+%22&type=code)                                                                                                                                                                                                                                                                                    | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| **Network Fields**                                                                                        |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [network.protocol](/docs/reference/ecs/ecs-network#field-network-protocol)                                | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [network.protocol.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network/#network-protocol-name)                                                                                                                                                                                                                                                                                     | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [network.transport](/docs/reference/ecs/ecs-network#field-network-transport)                              | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [network.transport](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network/#network-transport)                                                                                                                                                                                                                                                                                             | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [network.type](/docs/reference/ecs/ecs-network#field-network-type)                                        | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [network.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network/#network-type)                                                                                                                                                                                                                                                                                                       | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| **Operating System Fields**                                                                               |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [os.full](/docs/reference/ecs/ecs-os#field-os-full)                                                       | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [os.description](https://opentelemetry.io/docs/specs/semconv/attributes-registry/os/#os-description)                                                                                                                                                                                                                                                                                                        | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [os.name](/docs/reference/ecs/ecs-os#field-os-name)                                                       | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [os.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/os/#os-name)                                                                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [os.type](/docs/reference/ecs/ecs-os#field-os-type)                                                       | [![conflict](https://img.shields.io/badge/conflict-910000?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)     | [os.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/os/#os-type)Note: The expected values in ECS for `os.type` do not correspond with the values defined in semantic conventions!                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [os.version](/docs/reference/ecs/ecs-os#field-os-version)                                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [os.version](https://opentelemetry.io/docs/specs/semconv/attributes-registry/os/#os-version)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **Process Fields**                                                                                        |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [process.args](/docs/reference/ecs/ecs-process#field-process-args)                                        | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [process.command_args](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-command-args)                                                                                                                                                                                                                                                                                       | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [process.args_count](/docs/reference/ecs/ecs-process#field-process-args-count)                            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.args_count](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-args-count)                                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [process.command_line](/docs/reference/ecs/ecs-process#field-process-command-line)                        | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.command_line](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-command-line)                                                                                                                                                                                                                                                                                       | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [process.executable](/docs/reference/ecs/ecs-process#field-process-executable)                            | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [process.executable.path](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-executable-path)                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| process.real_user.id                                                                                      | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.real_user.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-real-user-id)                                                                                                                                                                                                                                                                                       | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| process.saved_user.id                                                                                     | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.saved_user.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-saved-user-id)                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| process.user.id                                                                                           | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.user.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-user-id)                                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [process.interactive](/docs/reference/ecs/ecs-process#field-process-interactive)                          | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.interactive](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-interactive)                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| process.real_user.name                                                                                    | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.real_user.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-real-user-name)                                                                                                                                                                                                                                                                                   | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| process.saved_user.name                                                                                   | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.saved_user.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-saved-user-name)                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| process.user.name                                                                                         | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.user.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-user-name)                                                                                                                                                                                                                                                                                             | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| process.group_leader.pid                                                                                  | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.group_leader.pid](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-group-leader-pid)                                                                                                                                                                                                                                                                               | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [process.pid](/docs/reference/ecs/ecs-process#field-process-pid)                                          | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.pid](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-pid)                                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| process.session_leader.pid                                                                                | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.session_leader.pid](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-session-leader-pid)                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [process.title](/docs/reference/ecs/ecs-process#field-process-title)                                      | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.title](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-title)                                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [process.uptime](/docs/reference/ecs/ecs-process#field-process-uptime)                                    | [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)         | [process.uptime](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.process.uptime+--%3E%22&type=code)                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [process.vpid](/docs/reference/ecs/ecs-process#field-process-vpid)                                        | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.vpid](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-vpid)                                                                                                                                                                                                                                                                                                       | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [process.working_directory](/docs/reference/ecs/ecs-process#field-process-working-directory)              | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [process.working_directory](https://opentelemetry.io/docs/specs/semconv/attributes-registry/process/#process-working-directory)                                                                                                                                                                                                                                                                             | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **Related Fields**                                                                                        |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [related.hash](/docs/reference/ecs/ecs-related#field-related-hash)                                        | [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)  | Not applicable.                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [related.hosts](/docs/reference/ecs/ecs-related#field-related-hosts)                                      | [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)  | Not applicable.                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [related.ip](/docs/reference/ecs/ecs-related#field-related-ip)                                            | [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)  | Not applicable.                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [related.user](/docs/reference/ecs/ecs-related#field-related-user)                                        | [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)  | Not applicable.                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| **Server Fields**                                                                                         |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [server.address](/docs/reference/ecs/ecs-server#field-server-address)                                     | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [server.address](https://opentelemetry.io/docs/specs/semconv/attributes-registry/server/#server-address)                                                                                                                                                                                                                                                                                                    | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [server.port](/docs/reference/ecs/ecs-server#field-server-port)                                           | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [server.port](https://opentelemetry.io/docs/specs/semconv/attributes-registry/server/#server-port)                                                                                                                                                                                                                                                                                                          | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| **Service Fields**                                                                                        |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [service.environment](/docs/reference/ecs/ecs-service#field-service-environment)                          | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [deployment.environment.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/deployment/#deployment-environment-name)                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [service.name](/docs/reference/ecs/ecs-service#field-service-name)                                        | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [service.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/service/#service-name)                                                                                                                                                                                                                                                                                                       | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [service.node.name](/docs/reference/ecs/ecs-service#field-service-node-name)                              | [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) | [service.instance.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/service/#service-instance-id)                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [service.version](/docs/reference/ecs/ecs-service#field-service-version)                                  | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [service.version](https://opentelemetry.io/docs/specs/semconv/attributes-registry/service/#service-version)                                                                                                                                                                                                                                                                                                 | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| **Source Fields**                                                                                         |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [source.address](/docs/reference/ecs/ecs-source#field-source-address)                                     | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [source.address](https://opentelemetry.io/docs/specs/semconv/attributes-registry/source/#source-address)                                                                                                                                                                                                                                                                                                    | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [source.port](/docs/reference/ecs/ecs-source#field-source-port)                                           | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [source.port](https://opentelemetry.io/docs/specs/semconv/attributes-registry/source/#source-port)                                                                                                                                                                                                                                                                                                          | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **TLS Fields**                                                                                            |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [tls.cipher](/docs/reference/ecs/ecs-tls#field-tls-cipher)                                                | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.cipher](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-cipher)                                                                                                                                                                                                                                                                                                               | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.certificate](/docs/reference/ecs/ecs-tls#field-tls-client-certificate)                        | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.certificate](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-certificate)                                                                                                                                                                                                                                                                                       | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.certificate_chain](/docs/reference/ecs/ecs-tls#field-tls-client-certificate-chain)            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.certificate_chain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-certificate-chain)                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.hash.md5](/docs/reference/ecs/ecs-tls#field-tls-client-hash-md5)                              | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.hash.md5](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-hash-md5)                                                                                                                                                                                                                                                                                             | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.hash.sha1](/docs/reference/ecs/ecs-tls#field-tls-client-hash-sha1)                            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.hash.sha1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-hash-sha1)                                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.hash.sha256](/docs/reference/ecs/ecs-tls#field-tls-client-hash-sha256)                        | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.hash.sha256](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-hash-sha256)                                                                                                                                                                                                                                                                                       | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.issuer](/docs/reference/ecs/ecs-tls#field-tls-client-issuer)                                  | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.issuer](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-issuer)                                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.ja3](/docs/reference/ecs/ecs-tls#field-tls-client-ja3)                                        | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.ja3](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-ja3)                                                                                                                                                                                                                                                                                                       | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.not_after](/docs/reference/ecs/ecs-tls#field-tls-client-not-after)                            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.not_after](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-not-after)                                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.not_before](/docs/reference/ecs/ecs-tls#field-tls-client-not-before)                          | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.not_before](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-not-before)                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.subject](/docs/reference/ecs/ecs-tls#field-tls-client-subject)                                | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.subject](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-subject)                                                                                                                                                                                                                                                                                               | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.client.supported_ciphers](/docs/reference/ecs/ecs-tls#field-tls-client-supported-ciphers)            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.client.supported_ciphers](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-client-supported-ciphers)                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.curve](/docs/reference/ecs/ecs-tls#field-tls-curve)                                                  | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.curve](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-curve)                                                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.established](/docs/reference/ecs/ecs-tls#field-tls-established)                                      | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.established](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-established)                                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.next_protocol](/docs/reference/ecs/ecs-tls#field-tls-next-protocol)                                  | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.next_protocol](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-next-protocol)                                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.resumed](/docs/reference/ecs/ecs-tls#field-tls-resumed)                                              | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.resumed](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-resumed)                                                                                                                                                                                                                                                                                                             | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.server.certificate](/docs/reference/ecs/ecs-tls#field-tls-server-certificate)                        | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.server.certificate](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-certificate)                                                                                                                                                                                                                                                                                       | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.server.certificate_chain](/docs/reference/ecs/ecs-tls#field-tls-server-certificate-chain)            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.server.certificate_chain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-certificate-chain)                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.server.hash.md5](/docs/reference/ecs/ecs-tls#field-tls-server-hash-md5)                              | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.server.hash.md5](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-hash-md5)                                                                                                                                                                                                                                                                                             | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.server.hash.sha1](/docs/reference/ecs/ecs-tls#field-tls-server-hash-sha1)                            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.server.hash.sha1](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-hash-sha1)                                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.server.hash.sha256](/docs/reference/ecs/ecs-tls#field-tls-server-hash-sha256)                        | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.server.hash.sha256](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-hash-sha256)                                                                                                                                                                                                                                                                                       | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.server.issuer](/docs/reference/ecs/ecs-tls#field-tls-server-issuer)                                  | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.server.issuer](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-issuer)                                                                                                                                                                                                                                                                                                 | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.server.ja3s](/docs/reference/ecs/ecs-tls#field-tls-server-ja3s)                                      | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.server.ja3s](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-ja3s)                                                                                                                                                                                                                                                                                                     | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.server.not_after](/docs/reference/ecs/ecs-tls#field-tls-server-not-after)                            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.server.not_after](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-not-after)                                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.server.not_before](/docs/reference/ecs/ecs-tls#field-tls-server-not-before)                          | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.server.not_before](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-not-before)                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [tls.server.subject](/docs/reference/ecs/ecs-tls#field-tls-server-subject)                                | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [tls.server.subject](https://opentelemetry.io/docs/specs/semconv/attributes-registry/tls/#tls-server-subject)                                                                                                                                                                                                                                                                                               | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **Tracing Fields**                                                                                        |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [span.id](/docs/reference/ecs/ecs-tracing#field-span-id)                                                  | [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)             | [span_id](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+span_id+%22&type=code)                                                                                                                                                                                                                                                                                                | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [trace.id](/docs/reference/ecs/ecs-tracing#field-trace-id)                                                | [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)             | [trace_id](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+trace_id+%22&type=code)                                                                                                                                                                                                                                                                                              | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [transaction.id](/docs/reference/ecs/ecs-tracing#field-transaction-id)                                    | [![not-applicable](https://img.shields.io/badge/n%2Fa-f2f4fb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)  | Not applicable.                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| **URL Fields**                                                                                            |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [url.domain](/docs/reference/ecs/ecs-url#field-url-domain)                                                | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.domain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-domain)                                                                                                                                                                                                                                                                                                               | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [url.extension](/docs/reference/ecs/ecs-url#field-url-extension)                                          | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.extension](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-extension)                                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [url.fragment](/docs/reference/ecs/ecs-url#field-url-fragment)                                            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.fragment](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-fragment)                                                                                                                                                                                                                                                                                                           | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [url.full](/docs/reference/ecs/ecs-url#field-url-full)                                                    | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.full](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-full)                                                                                                                                                                                                                                                                                                                   | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [url.original](/docs/reference/ecs/ecs-url#field-url-original)                                            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.original](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-original)                                                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [url.path](/docs/reference/ecs/ecs-url#field-url-path)                                                    | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.path](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-path)                                                                                                                                                                                                                                                                                                                   | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [url.port](/docs/reference/ecs/ecs-url#field-url-port)                                                    | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.port](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-port)                                                                                                                                                                                                                                                                                                                   | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [url.query](/docs/reference/ecs/ecs-url#field-url-query)                                                  | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.query](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-query)                                                                                                                                                                                                                                                                                                                 | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [url.registered_domain](/docs/reference/ecs/ecs-url#field-url-registered-domain)                          | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.registered_domain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-registered-domain)                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [url.scheme](/docs/reference/ecs/ecs-url#field-url-scheme)                                                | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.scheme](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-scheme)                                                                                                                                                                                                                                                                                                               | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [url.subdomain](/docs/reference/ecs/ecs-url#field-url-subdomain)                                          | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.subdomain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-subdomain)                                                                                                                                                                                                                                                                                                         | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [url.top_level_domain](/docs/reference/ecs/ecs-url#field-url-top-level-domain)                            | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [url.top_level_domain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-top-level-domain)                                                                                                                                                                                                                                                                                           | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **User Fields**                                                                                           |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [user.email](/docs/reference/ecs/ecs-user#field-user-email)                                               | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [user.email](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-email)                                                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [user.full_name](/docs/reference/ecs/ecs-user#field-user-full-name)                                       | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [user.full_name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-full-name)                                                                                                                                                                                                                                                                                                      | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [user.hash](/docs/reference/ecs/ecs-user#field-user-hash)                                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [user.hash](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-hash)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [user.id](/docs/reference/ecs/ecs-user#field-user-id)                                                     | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [user.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-id)                                                                                                                                                                                                                                                                                                                    | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [user.name](/docs/reference/ecs/ecs-user#field-user-name)                                                 | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [user.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-name)                                                                                                                                                                                                                                                                                                                | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [user.roles](/docs/reference/ecs/ecs-user#field-user-roles)                                               | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [user.roles](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-roles)                                                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| **User agent Fields**                                                                                     |                                                                                                                                              |                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                  |
| [user_agent.name](/docs/reference/ecs/ecs-user_agent#field-user-agent-name)                               | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [user_agent.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user-agent/#user-agent-name)                                                                                                                                                                                                                                                                                              | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |
| [user_agent.original](/docs/reference/ecs/ecs-user_agent#field-user-agent-original)                       | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [user_agent.original](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user-agent/#user-agent-original)                                                                                                                                                                                                                                                                                      | ![stable](https://img.shields.io/badge/✔-93c93e?style=flat)      |
| [user_agent.version](/docs/reference/ecs/ecs-user_agent#field-user-agent-version)                         | [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation)           | [user_agent.version](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user-agent/#user-agent-version)                                                                                                                                                                                                                                                                                        | ![development](https://img.shields.io/badge/✘-fed10c?style=flat) |