﻿---
title: Operating System fields
description: The OS fields contain information about the operating system. The os fields are expected to be nested at: host.os, observer.os, user_agent.os. Note also...
url: https://www.elastic.co/docs/reference/ecs/ecs-os
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Operating System fields
The OS fields contain information about the operating system.

## Operating System field details


| Field                             | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Level    |
|-----------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [os.family](#field-os-family)     | OS family (such as redhat, debian, freebsd, windows).type: keywordexample: `debian`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | extended |
| [os.full](#field-os-full)         | Operating system name, including the version or code name.type: keywordMulti-fields:* os.full.text (type: match_only_text)example: `Mac OS Mojave`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [os.description](https://opentelemetry.io/docs/specs/semconv/attributes-registry/os/#os-description)                                                                                                                                                                                                                                                                                                                                                        | extended |
| [os.kernel](#field-os-kernel)     | Operating system kernel version as a raw string.type: keywordexample: `4.4.0-112-generic`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [os.name](#field-os-name)         | Operating system name, without the version.type: keywordMulti-fields:* os.name.text (type: match_only_text)example: `Mac OS X`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [os.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/os/#os-name)                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [os.platform](#field-os-platform) | Operating system platform (such centos, ubuntu, windows).type: keywordexample: `darwin`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [os.type](#field-os-type)         | Use the `os.type` field to categorize the operating system into one of the broad commercial families.If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition.Expected values for this field:* `linux`* `macos`* `unix`* `windows`* `ios`* `android`type: keywordexample: `macos`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![conflict](https://img.shields.io/badge/conflict-910000?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [os.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/os/#os-type)**Note:** The expected values in ECS for `os.type` do not correspond with the values defined in semantic conventions! | extended |
| [os.version](#field-os-version)   | Operating system version as a raw string.type: keywordexample: `10.14.1`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [os.version](https://opentelemetry.io/docs/specs/semconv/attributes-registry/os/#os-version)                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |


## Field reuse

The `os` fields are expected to be nested at:
- `host.os`
- `observer.os`
- `user_agent.os`

Note also that the `os` fields are not expected to be used directly at the root of the events.