﻿---
title: Orchestrator fields
description: Fields that describe the resources which container orchestrators manage or act upon. 
url: https://www.elastic.co/docs/reference/ecs/ecs-orchestrator
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Orchestrator fields
Fields that describe the resources which container orchestrators manage or act upon.

## Orchestrator field details


| Field                                                                         | Description                                                                                                                                                                                                                                                                                  | Level    |
|-------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [orchestrator.api_version](#field-orchestrator-api-version)                   | API version being used to carry out the actiontype: keywordexample: `v1beta1`                                                                                                                                                                                                                | extended |
| [orchestrator.cluster.id](#field-orchestrator-cluster-id)                     | Unique ID of the cluster.type: keyword                                                                                                                                                                                                                                                       | extended |
| [orchestrator.cluster.name](#field-orchestrator-cluster-name)                 | Name of the cluster.type: keyword                                                                                                                                                                                                                                                            | extended |
| [orchestrator.cluster.url](#field-orchestrator-cluster-url)                   | URL of the API used to manage the cluster.type: keyword                                                                                                                                                                                                                                      | extended |
| [orchestrator.cluster.version](#field-orchestrator-cluster-version)           | The version of the cluster.type: keyword                                                                                                                                                                                                                                                     | extended |
| [orchestrator.namespace](#field-orchestrator-namespace)                       | Namespace in which the action is taking place.type: keywordexample: `kube-system`                                                                                                                                                                                                            | extended |
| [orchestrator.organization](#field-orchestrator-organization)                 | Organization affected by the event (for multi-tenant orchestrator setups).type: keywordexample: `elastic`                                                                                                                                                                                    | extended |
| [orchestrator.resource.annotation](#field-orchestrator-resource-annotation)   | The list of annotations added to the resource.type: keywordNote: This field should contain an array of values.example: `['key1:value1', 'key2:value2', 'key3:value3']`                                                                                                                       | extended |
| [orchestrator.resource.id](#field-orchestrator-resource-id)                   | Unique ID of the resource being acted upon.type: keyword                                                                                                                                                                                                                                     | extended |
| [orchestrator.resource.ip](#field-orchestrator-resource-ip)                   | IP address assigned to the resource associated with the event being observed. In the case of a Kubernetes Pod, this array would contain only one element: the IP of the Pod (as opposed to the Node on which the Pod is running).type: ipNote: This field should contain an array of values. | extended |
| [orchestrator.resource.label](#field-orchestrator-resource-label)             | The list of labels added to the resource.type: keywordNote: This field should contain an array of values.example: `['key1:value1', 'key2:value2', 'key3:value3']`                                                                                                                            | extended |
| [orchestrator.resource.name](#field-orchestrator-resource-name)               | Name of the resource being acted upon.type: keywordexample: `test-pod-cdcws`                                                                                                                                                                                                                 | extended |
| [orchestrator.resource.parent.type](#field-orchestrator-resource-parent-type) | Type or kind of the parent resource associated with the event being observed. In Kubernetes, this will be the name of a built-in workload resource (e.g., Deployment, StatefulSet, DaemonSet).type: keywordexample: `DaemonSet`                                                              | extended |
| [orchestrator.resource.type](#field-orchestrator-resource-type)               | Type of resource being acted upon.type: keywordexample: `service`                                                                                                                                                                                                                            | extended |
| [orchestrator.type](#field-orchestrator-type)                                 | Orchestrator cluster type (e.g. kubernetes, nomad or cloudfoundry).type: keywordexample: `kubernetes`                                                                                                                                                                                        | extended |


### Field sets that can be nested under Orchestrator


| Location                | Field Set                                                      | Description                                                          |
|-------------------------|----------------------------------------------------------------|----------------------------------------------------------------------|
| `orchestrator.entity.*` | [entity](https://www.elastic.co/docs/reference/ecs/ecs-entity) | Fields to describe various types of entities across IT environments. |