﻿---
title: Observer fields
description: An observer is defined as a special network, security, or application device used to detect, observe, or create network, security, or application-related...
url: https://www.elastic.co/docs/reference/ecs/ecs-observer
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Observer fields
An observer is defined as a special network, security, or application device used to detect, observe, or create network, security, or application-related events and metrics.
This could be a custom hardware appliance or a server that has been configured to run special network, security, or application software. Examples include firewalls, web proxies, intrusion detection/prevention systems, network monitoring sensors, web application firewalls, data loss prevention systems, and APM servers. The observer.* fields shall be populated with details of the system, if any, that detects, observes and/or creates a network, security, or application event or metric. Message queues and ETL components used in processing events or metrics are not considered observers in ECS.

## Observer field details


| Field                                                   | Description                                                                                                                                                                                                                                                                                                                                                                                 | Level    |
|---------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [observer.egress](#field-observer-egress)               | Observer.egress holds information like interface number and name, vlan, and zone information to classify egress traffic.  Single armed monitoring such as a network sensor on a span port should only use observer.ingress to categorize traffic.type: object                                                                                                                               | extended |
| [observer.egress.zone](#field-observer-egress-zone)     | Network zone of outbound traffic as reported by the observer to categorize the destination area of egress traffic, e.g. Internal, External, DMZ, HR, Legal, etc.type: keywordexample: `Public_Internet`                                                                                                                                                                                     | extended |
| [observer.hostname](#field-observer-hostname)           | Hostname of the observer.type: keyword                                                                                                                                                                                                                                                                                                                                                      | core     |
| [observer.ingress](#field-observer-ingress)             | Observer.ingress holds information like interface number and name, vlan, and zone information to classify ingress traffic.  Single armed monitoring such as a network sensor on a span port should only use observer.ingress to categorize traffic.type: object                                                                                                                             | extended |
| [observer.ingress.zone](#field-observer-ingress-zone)   | Network zone of incoming traffic as reported by the observer to categorize the source area of ingress traffic. e.g. internal, External, DMZ, HR, Legal, etc.type: keywordexample: `DMZ`                                                                                                                                                                                                     | extended |
| [observer.ip](#field-observer-ip)                       | IP addresses of the observer.type: ipNote: This field should contain an array of values.                                                                                                                                                                                                                                                                                                    | core     |
| [observer.mac](#field-observer-mac)                     | MAC addresses of the observer.The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.type: keywordNote: This field should contain an array of values.example: `["00-00-5E-00-53-23", "00-00-5E-00-53-24"]` | core     |
| [observer.name](#field-observer-name)                   | Custom name of the observer.This is a name that can be given to an observer. This can be helpful for example if multiple firewalls of the same model are used in an organization.If no custom name is needed, the field can be left empty.type: keywordexample: `1_proxySG`                                                                                                                 | extended |
| [observer.product](#field-observer-product)             | The product name of the observer.type: keywordexample: `s200`                                                                                                                                                                                                                                                                                                                               | extended |
| [observer.serial_number](#field-observer-serial-number) | Observer serial number.type: keyword                                                                                                                                                                                                                                                                                                                                                        | extended |
| [observer.type](#field-observer-type)                   | The type of the observer the data is coming from.There is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`.type: keywordexample: `firewall`                                                                                                                                                         | core     |
| [observer.vendor](#field-observer-vendor)               | Vendor name of the observer.type: keywordexample: `Symantec`                                                                                                                                                                                                                                                                                                                                | core     |
| [observer.version](#field-observer-version)             | Observer version.type: keyword                                                                                                                                                                                                                                                                                                                                                              | core     |


### Field sets that can be nested under Observer


| Location                       | Field Set                                                            | Description                                               |
|--------------------------------|----------------------------------------------------------------------|-----------------------------------------------------------|
| `observer.egress.interface.*`  | [interface](https://www.elastic.co/docs/reference/ecs/ecs-interface) | Fields to describe observer interface information.        |
| `observer.egress.vlan.*`       | [vlan](https://www.elastic.co/docs/reference/ecs/ecs-vlan)           | Fields to describe observed VLAN information.             |
| `observer.geo.*`               | [geo](https://www.elastic.co/docs/reference/ecs/ecs-geo)             | Fields describing a location.                             |
| `observer.ingress.interface.*` | [interface](https://www.elastic.co/docs/reference/ecs/ecs-interface) | Fields to describe observer interface information.        |
| `observer.ingress.vlan.*`      | [vlan](https://www.elastic.co/docs/reference/ecs/ecs-vlan)           | Fields to describe observed VLAN information.             |
| `observer.os.*`                | [os](https://www.elastic.co/docs/reference/ecs/ecs-os)               | OS fields contain information about the operating system. |