﻿---
title: Network fields
description: The network is defined as the communication path over which a host or network event happens. The network.* fields should be populated with details about...
url: https://www.elastic.co/docs/reference/ecs/ecs-network
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Network fields
The network is defined as the communication path over which a host or network event happens.
The network.* fields should be populated with details about the network activity associated with an event.

## Network field details


| Field                                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Level    |
|-----------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [network.application](#field-network-application)   | When a specific application or service is identified from network connection details (source/dest IPs, ports, certificates, or wire format), this field captures the application's or service's name.For example, the original event identifies the network connection being from a specific web service in a `https` network connection, like `facebook` or `twitter`.The field value must be normalized to lowercase for querying.type: keywordexample: `aim`                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [network.bytes](#field-network-bytes)               | Total bytes transferred in both directions.If `source.bytes` and `destination.bytes` are known, `network.bytes` is their sum.type: longexample: `368`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | core     |
| [network.community_id](#field-network-community-id) | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows.Learn more at [https://github.com/corelight/community-id-spec](https://github.com/corelight/community-id-spec).type: keywordexample: `1:hO+sN4H+MG5MY/8hIrXPqc4ZQz0=`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [network.direction](#field-network-direction)       | Direction of the network traffic.When mapping events from a host-based monitoring context, populate this field from the host's point of view, using the values "ingress" or "egress".When mapping events from a network or perimeter-based monitoring context, populate this field from the point of view of the network perimeter, using the values "inbound", "outbound", "internal" or "external".Note that "internal" is not crossing perimeter boundaries, and is meant to describe communication between two hosts within the perimeter. Note also that "external" is meant to describe traffic between two hosts that are external to the perimeter. This could for example be useful for ISPs or VPN service providers.Expected values for this field:* `ingress`* `egress`* `inbound`* `outbound`* `internal`* `external`* `unknown`type: keywordexample: `inbound` | core     |
| [network.forwarded_ip](#field-network-forwarded-ip) | Host IP address when the source IP address is the proxy.type: ipexample: `192.1.1.2`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | core     |
| [network.iana_number](#field-network-iana-number)   | IANA Protocol Number ([https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)). Standardized list of protocols. This aligns well with NetFlow and sFlow related logs which use the IANA Protocol Number.type: keywordexample: `6`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [network.inner](#field-network-inner)               | Network.inner fields are added in addition to network.vlan fields to describe the innermost VLAN when q-in-q VLAN tagging is present. Allowed fields include vlan.id and vlan.name. Inner vlan fields are typically used when sending traffic with multiple 802.1q encapsulations to a network sensor (e.g. Zeek, Wireshark.)type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [network.name](#field-network-name)                 | Name given by operators to sections of their network.type: keywordexample: `Guest Wifi`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | extended |
| [network.packets](#field-network-packets)           | Total packets transferred in both directions.If `source.packets` and `destination.packets` are known, `network.packets` is their sum.type: longexample: `24`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | core     |
| [network.protocol](#field-network-protocol)         | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`.The field value must be normalized to lowercase for querying.type: keywordexample: `http`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [network.protocol.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network/#network-protocol-name)                                                                                                                                                                                                                                                                                                             | core     |
| [network.transport](#field-network-transport)       | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.)The field value must be normalized to lowercase for querying.type: keywordexample: `tcp`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [network.transport](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network/#network-transport)                                                                                                                                                                                                                                                                                                                  | core     |
| [network.type](#field-network-type)                 | In the OSI Model this would be the Network Layer. ipv4, ipv6, ipsec, pim, etcThe field value must be normalized to lowercase for querying.type: keywordexample: `ipv4`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [network.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network/#network-type)                                                                                                                                                                                                                                                                                                                                                                | core     |


### Field sets that can be nested under Network


| Location               | Field Set                                                  | Description                                   |
|------------------------|------------------------------------------------------------|-----------------------------------------------|
| `network.inner.vlan.*` | [vlan](https://www.elastic.co/docs/reference/ecs/ecs-vlan) | Fields to describe observed VLAN information. |
| `network.vlan.*`       | [vlan](https://www.elastic.co/docs/reference/ecs/ecs-vlan) | Fields to describe observed VLAN information. |