﻿---
title: Mach-O Header fields
description: These fields contain Mac OS Mach Object file format (Mach-O) metadata. The macho fields are expected to be nested at: file.macho, process.macho. Note...
url: https://www.elastic.co/docs/reference/ecs/ecs-macho
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Mach-O Header fields
These fields contain Mac OS Mach Object file format (Mach-O) metadata.
<warning>
  These fields are in beta and are subject to change.
</warning>


## Mach-O Header field details


| Field                                                                           | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Level    |
|---------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [macho.go_import_hash](#field-macho-go-import-hash)                             | A hash of the Go language imports in a Mach-O file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.The algorithm used to calculate the Go symbol hash and a reference implementation are available here: [https://github.com/elastic/toutoumomoma](https://github.com/elastic/toutoumomoma)type: keywordexample: `10bddcb4cee42080f76c88d9ff964491` | extended |
| [macho.go_imports](#field-macho-go-imports)                                     | List of imported Go language element names and types.type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [macho.go_imports_names_entropy](#field-macho-go-imports-names-entropy)         | Shannon entropy calculation from the list of Go imports.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                     | extended |
| [macho.go_imports_names_var_entropy](#field-macho-go-imports-names-var-entropy) | Variance for Shannon entropy calculation from the list of Go imports.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [macho.go_stripped](#field-macho-go-stripped)                                   | Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.type: boolean                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [macho.import_hash](#field-macho-import-hash)                                   | A hash of the imports in a Mach-O file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.This is a synonym for symhash.type: keywordexample: `d41d8cd98f00b204e9800998ecf8427e`                                                                                                                                                                                                          | extended |
| [macho.imports](#field-macho-imports)                                           | List of imported element names and types.type: flattenedNote: This field should contain an array of values.                                                                                                                                                                                                                                                                                                                                                                                                            | extended |
| [macho.imports_names_entropy](#field-macho-imports-names-entropy)               | Shannon entropy calculation from the list of imported element names and types.type: long                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [macho.imports_names_var_entropy](#field-macho-imports-names-var-entropy)       | Variance for Shannon entropy calculation from the list of imported element names and types.type: long                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [macho.sections](#field-macho-sections)                                         | An array containing an object for each section of the Mach-O file.The keys that should be present in these objects are defined by sub-fields underneath `macho.sections.*`.type: nestedNote: This field should contain an array of values.                                                                                                                                                                                                                                                                             | extended |
| [macho.sections.entropy](#field-macho-sections-entropy)                         | Shannon entropy calculation from the section.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [macho.sections.name](#field-macho-sections-name)                               | Mach-O Section List name.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [macho.sections.physical_size](#field-macho-sections-physical-size)             | Mach-O Section List physical size.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [macho.sections.var_entropy](#field-macho-sections-var-entropy)                 | Variance for Shannon entropy calculation from the section.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [macho.sections.virtual_size](#field-macho-sections-virtual-size)               | Mach-O Section List virtual size. This is always the same as `physical_size`.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [macho.symhash](#field-macho-symhash)                                           | A hash of the imports in a Mach-O file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.This is a Mach-O implementation of the Windows PE imphashtype: keywordexample: `d3ccf195b62a9279c3c19af1080497ec`                                                                                                                                                                               | extended |


## Field reuse

The `macho` fields are expected to be nested at:
- `file.macho`
- `process.macho`

Note also that the `macho` fields are not expected to be used directly at the root of the events.