﻿---
title: Log fields
description: Details about the event's logging mechanism or logging transport. The log.* fields are typically populated with details about the logging mechanism used...
url: https://www.elastic.co/docs/reference/ecs/ecs-log
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Log fields
Details about the event's logging mechanism or logging transport.
The log.* fields are typically populated with details about the logging mechanism used to create and/or transport the event. For example, syslog details belong under `log.syslog.*`.
The details specific to your event source are typically not logged under `log.*`, but rather in `event.*` or in other ECS fields.

## Log field details


| Field                                                           | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Level    |
|-----------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [log.file.path](#field-log-file-path)                           | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate.If the event wasn't read from a log file, do not populate this field.type: keywordexample: `/var/log/fun-times.log`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [log.file.path](https://opentelemetry.io/docs/specs/semconv/attributes-registry/log/#log-file-path)                                                                                                                     | extended |
| [log.level](#field-log-level)                                   | Original log level of the log event.If the source of the event provides a log level or textual severity, this is the one that goes in `log.level`. If your source doesn't specify one, you may put your event transport's severity here (e.g. Syslog severity).Some examples are `warn`, `err`, `i`, `informational`.type: keywordexample: `error`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [severity_text](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+severity_text+%22&type=code) | core     |
| [log.logger](#field-log-logger)                                 | The name of the logger inside an application. This is usually the name of the class which initialized the logger, or can be a custom name.type: keywordexample: `org.elasticsearch.bootstrap.Bootstrap`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | core     |
| [log.origin.file.line](#field-log-origin-file-line)             | The line number of the file containing the source code which originated the log event.type: longexample: `42`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [log.origin.file.name](#field-log-origin-file-name)             | The name of the file containing the source code which originated the log event.Note that this field is not meant to capture the log file. The correct field to capture the log file is `log.file.path`.type: keywordexample: `Bootstrap.java`                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [log.origin.function](#field-log-origin-function)               | The name of the function or method which originated the log event.type: keywordexample: `init`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [log.syslog](#field-log-syslog)                                 | The Syslog metadata of the event, if the event was transmitted via Syslog. Please see RFCs 5424 or 3164.type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | extended |
| [log.syslog.appname](#field-log-syslog-appname)                 | The device or application that originated the Syslog message, if available.type: keywordexample: `sshd`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [log.syslog.facility.code](#field-log-syslog-facility-code)     | The Syslog numeric facility of the log event, if available.According to RFCs 5424 and 3164, this value should be an integer between 0 and 23.type: longexample: `23`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | extended |
| [log.syslog.facility.name](#field-log-syslog-facility-name)     | The Syslog text-based facility of the log event, if available.type: keywordexample: `local7`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [log.syslog.hostname](#field-log-syslog-hostname)               | The hostname, FQDN, or IP of the machine that originally sent the Syslog message. This is sourced from the hostname field of the syslog header. Depending on the environment, this value may be different from the host that handled the event, especially if the host handling the events is acting as a collector.type: keywordexample: `example-host`                                                                                                                                                                                                                                                                                                                                                   | extended |
| [log.syslog.msgid](#field-log-syslog-msgid)                     | An identifier for the type of Syslog message, if available. Only applicable for RFC 5424 messages.type: keywordexample: `ID47`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [log.syslog.priority](#field-log-syslog-priority)               | Syslog numeric priority of the event, if available.According to RFCs 5424 and 3164, the priority is 8 * facility + severity. This number is therefore expected to contain a value between 0 and 191.type: longexample: `135`                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [log.syslog.procid](#field-log-syslog-procid)                   | The process name or ID that originated the Syslog message, if available.type: keywordexample: `12345`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | extended |
| [log.syslog.severity.code](#field-log-syslog-severity-code)     | The Syslog numeric severity of the log event, if available.If the event source publishing via Syslog provides a different numeric severity value (e.g. firewall, IDS), your source's numeric severity should go to `event.severity`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `event.severity`.type: longexample: `3`                                                                                                                                                                                                                                                                                                                      | extended |
| [log.syslog.severity.name](#field-log-syslog-severity-name)     | The Syslog numeric severity of the log event, if available.If the event source publishing via Syslog provides a different severity value (e.g. firewall, IDS), your source's text severity should go to `log.level`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `log.level`.type: keywordexample: `Error`                                                                                                                                                                                                                                                                                                                                    | extended |
| [log.syslog.structured_data](#field-log-syslog-structured-data) | Structured data expressed in RFC 5424 messages, if available. These are key-value pairs formed from the structured data portion of the syslog message, as defined in RFC 5424 Section 6.3.type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [log.syslog.version](#field-log-syslog-version)                 | The version of the Syslog protocol specification. Only applicable for RFC 5424 messages.type: keywordexample: `1`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | extended |