﻿---
title: Interface fields
description: The interface fields are used to record ingress and egress interface information when reported by an observer (e.g. firewall, router, load balancer) in...
url: https://www.elastic.co/docs/reference/ecs/ecs-interface
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Interface fields
The interface fields are used to record ingress and egress interface information when reported by an observer (e.g. firewall, router, load balancer) in the context of the observer handling a network connection.  In the case of a single observer interface (e.g. network sensor on a span port) only the observer.ingress information should be populated.

## Interface field details


| Field                                     | Description                                                                                                                                                                     | Level    |
|-------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [interface.alias](#field-interface-alias) | Interface alias as reported by the system, typically used in firewall implementations for e.g. inside, outside, or dmz logical interface naming.type: keywordexample: `outside` | extended |
| [interface.id](#field-interface-id)       | Interface ID as reported by an observer (typically SNMP interface ID).type: keywordexample: `10`                                                                                | extended |
| [interface.name](#field-interface-name)   | Interface name as reported by the system.type: keywordexample: `eth0`                                                                                                           | extended |


## Field reuse

The `interface` fields are expected to be nested at:
- `observer.egress.interface`
- `observer.ingress.interface`

Note also that the `interface` fields are not expected to be used directly at the root of the events.