﻿---
title: HTTP fields
description: Fields related to HTTP activity. Use the url field set to store the url of the request. 
url: https://www.elastic.co/docs/reference/ecs/ecs-http
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# HTTP fields
Fields related to HTTP activity. Use the `url` field set to store the url of the request.

## HTTP field details


| Field                                                           | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Level    |
|-----------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [http.request.body.bytes](#field-http-request-body-bytes)       | Size in bytes of the request body.type: longexample: `887`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [http.request.body.size](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-request-body-size)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [http.request.body.content](#field-http-request-body-content)   | The full HTTP request body.type: wildcardMulti-fields:* http.request.body.content.text (type: match_only_text)example: `Hello world`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | extended |
| [http.request.bytes](#field-http-request-bytes)                 | Total size in bytes of the request (body and headers).type: longexample: `1437`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [http.request.size](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-request-size)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [http.request.id](#field-http-request-id)                       | A unique identifier for each HTTP request to correlate logs between clients and servers in transactions.The id may be contained in a non-standard HTTP header, such as `X-Request-ID` or `X-Correlation-ID`.type: keywordexample: `123e4567-e89b-12d3-a456-426614174000`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [http.request.method](#field-http-request-method)               | HTTP request method.The value should retain its casing from the original event. For example, `GET`, `get`, and `GeT` are all considered valid values for this field.type: keywordexample: `POST`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [http.request.method_original](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-request-method-original)![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![conflict](https://img.shields.io/badge/conflict-910000?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [http.request.method](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-request-method)**Note:** `http.request.method` in SemConv is the known, normalized, upper case value of the request method, other than the ECS' `http.request.method` that retains casing from the original event. | extended |
| [http.request.mime_type](#field-http-request-mime-type)         | Mime type of the body of the request.This value must only be populated based on the content of the request body, not on the `Content-Type` header. Comparing the mime type of a request with the request's Content-Type header can be helpful in detecting threats or misconfigured clients.type: keywordexample: `image/gif`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [http.request.referrer](#field-http-request-referrer)           | Referrer for this HTTP request.type: keywordexample: `https://blog.example.com/`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [http.response.body.bytes](#field-http-response-body-bytes)     | Size in bytes of the response body.type: longexample: `887`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [http.response.body.size](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-response-body-size)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [http.response.body.content](#field-http-response-body-content) | The full HTTP response body.type: wildcardMulti-fields:* http.response.body.content.text (type: match_only_text)example: `Hello world`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [http.response.bytes](#field-http-response-bytes)               | Total size in bytes of the response (body and headers).type: longexample: `1437`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [http.response.size](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-response-size)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [http.response.mime_type](#field-http-response-mime-type)       | Mime type of the body of the response.This value must only be populated based on the content of the response body, not on the `Content-Type` header. Comparing the mime type of a response with the response's Content-Type header can be helpful in detecting misconfigured servers.type: keywordexample: `image/gif`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [http.response.status_code](#field-http-response-status-code)   | HTTP response status code.type: longexample: `404`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [http.response.status_code](https://opentelemetry.io/docs/specs/semconv/attributes-registry/http/#http-response-status-code)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [http.version](#field-http-version)                             | HTTP version.type: keywordexample: `1.1`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [network.protocol.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network/#network-protocol-name)![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [network.protocol.version](https://opentelemetry.io/docs/specs/semconv/attributes-registry/network/#network-protocol-version)**Note:** In OTel SemConv, `network.protocol.version` specifies the HTTP version if the value of `network.protocol.name` is `http`.                                                                                                                                                                                                                               | extended |