﻿---
title: Host fields
description: A host is defined as a general computing instance. ECS host.* fields should be populated with details about the host on which the event happened, or from...
url: https://www.elastic.co/docs/reference/ecs/ecs-host
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Host fields
A host is defined as a general computing instance.
ECS host.* fields should be populated with details about the host on which the event happened, or from which the measurement was taken. Host types include hardware, virtual machines, Docker containers, and Kubernetes nodes.

## Host field details


| Field                                                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Level    |
|---------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [host.architecture](#field-host-architecture)                       | Operating system architecture.type: keywordexample: `x86_64`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [host.arch](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-arch)                                                                                                                                                                                                                                                                                                         | core     |
| [host.boot.id](#field-host-boot-id)                                 | Linux boot uuid taken from /proc/sys/kernel/random/boot_id. Note the boot_id value from /proc may or may not be the same in containers as on the host. Some container runtimes will bind mount a new boot_id value onto the proc file in each container.type: keywordexample: `88a1f0ed-5ae5-41ee-af6b-41921c311872`                                                                                                                                                                                                                                                                                                                                                                                         | extended |
| [host.cpu.usage](#field-host-cpu-usage)                             | Percent CPU used which is normalized by the number of CPU cores and it ranges from 0 to 1.Scaling factor: 1000.For example: For a two core host, this value should be the average of the two cores, between 0 and 1.type: scaled_float![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [system.cpu.utilization](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.cpu.utilization+--%3E%22&type=code)                                                            | extended |
| [host.disk.read.bytes](#field-host-disk-read-bytes)                 | The total number of bytes (gauge) read successfully (aggregated from all disks) since the last metric collection.type: long![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [system.disk.io](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.disk.io+--%3E%22&type=code)                                                                                                                                                                                       | extended |
| [host.disk.write.bytes](#field-host-disk-write-bytes)               | The total number of bytes (gauge) written successfully (aggregated from all disks) since the last metric collection.type: long![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [system.disk.io](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.disk.io+--%3E%22&type=code)                                                                                                                                                                                    | extended |
| [host.domain](#field-host-domain)                                   | Name of the domain of which the host is a member.For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.type: keywordexample: `CONTOSO`                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [host.hostname](#field-host-hostname)                               | Hostname of the host.It normally contains what the `hostname` command returns on the host machine.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | core     |
| [host.id](#field-host-id)                                           | Unique host id.As hostname is not always unique, use values that are meaningful in your environment.Example: The current usage of `beat.name`.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [host.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-id)                                                                                                                                                                                                                        | core     |
| [host.ip](#field-host-ip)                                           | Host ip addresses.type: ipNote: This field should contain an array of values.![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [host.ip](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-ip)                                                                                                                                                                                                                                                                                                      | core     |
| [host.mac](#field-host-mac)                                         | Host MAC addresses.The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.type: keywordNote: This field should contain an array of values.example: `["00-00-5E-00-53-23", "00-00-5E-00-53-24"]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [host.mac](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-mac) | core     |
| [host.name](#field-host-name)                                       | Name of the host.It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [host.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-name)                                                                                                                                                          | core     |
| [host.network.egress.bytes](#field-host-network-egress-bytes)       | The number of bytes (gauge) sent out on all network interfaces by the host since the last metric collection.type: long![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [system.network.io](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.network.io+--%3E%22&type=code)                                                                                                                                                                                      | extended |
| [host.network.egress.packets](#field-host-network-egress-packets)   | The number of packets (gauge) sent out on all network interfaces by the host since the last metric collection.type: long![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [system.network.packet.count](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.network.packet.count+--%3E%22&type=code)                                                                                                                                                                | extended |
| [host.network.ingress.bytes](#field-host-network-ingress-bytes)     | The number of bytes received (gauge) on all network interfaces by the host since the last metric collection.type: long![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [system.network.io](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.network.io+--%3E%22&type=code)                                                                                                                                                                                      | extended |
| [host.network.ingress.packets](#field-host-network-ingress-packets) | The number of packets (gauge) received on all network interfaces by the host since the last metric collection.type: long![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [system.network.packet.count](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.network.packet.count+--%3E%22&type=code)                                                                                                                                                                | extended |
| [host.pid_ns_ino](#field-host-pid-ns-ino)                           | This is the inode number of the namespace in the namespace file system (nsfs). Unsigned int inum in include/linux/ns_common.h.type: keywordexample: `256383`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [host.type](#field-host-type)                                       | Type of host.For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [host.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/host/#host-type)                                                                                                                                                                             | core     |
| [host.uptime](#field-host-uptime)                                   | Seconds the host has been up.type: longexample: `1325`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [system.uptime](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.system.uptime+--%3E%22&type=code)                                                                                                                                                                                                                                                              | extended |


## Field reuse

The `host` fields are expected to be nested at:
- `host.target`

Note also that the `host` fields may be used directly at the root of the events.

### Field sets that can be nested under Host


| Location        | Field Set                                                      | Description                                                          |
|-----------------|----------------------------------------------------------------|----------------------------------------------------------------------|
| `host.entity.*` | [entity](https://www.elastic.co/docs/reference/ecs/ecs-entity) | Fields to describe various types of entities across IT environments. |
| `host.geo.*`    | [geo](https://www.elastic.co/docs/reference/ecs/ecs-geo)       | Fields describing a location.                                        |
| `host.os.*`     | [os](https://www.elastic.co/docs/reference/ecs/ecs-os)         | OS fields contain information about the operating system.            |
| `host.risk.*`   | [risk](https://www.elastic.co/docs/reference/ecs/ecs-risk)     | Fields for describing risk score and level.                          |
| `host.target.*` | [host](https://www.elastic.co/docs/reference/ecs/ecs-host)     | Targeted host of action taken.                                       |