﻿---
title: Hash fields
description: The hash fields represent different bitwise hash algorithms and their values. Field names for common hashes (e.g. MD5, SHA1) are predefined. Add fields...
url: https://www.elastic.co/docs/reference/ecs/ecs-hash
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Hash fields
The hash fields represent different bitwise hash algorithms and their values.
Field names for common hashes (e.g. MD5, SHA1) are predefined. Add fields for other hashes by lowercasing the hash algorithm name and using underscore separators as appropriate (snake case, e.g. sha3_512).
Note that this fieldset is used for common hashes that may be computed over a range of generic bytes. Entity-specific hashes such as ja3 or imphash are placed in the fieldsets to which they relate (tls and pe, respectively).

## Hash field details


| Field                             | Description                                                                                                                                                                                                           | Level    |
|-----------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [hash.cdhash](#field-hash-cdhash) | _This field is beta and subject to change._ Code directory hash, utilized to uniquely identify and authenticate the integrity of the executable code.type: keywordexample: `3783b4052fd474dbe30676b45c329e7a6d44acd9` | extended |
| [hash.md5](#field-hash-md5)       | MD5 hash.type: keyword                                                                                                                                                                                                | extended |
| [hash.sha1](#field-hash-sha1)     | SHA1 hash.type: keyword                                                                                                                                                                                               | extended |
| [hash.sha256](#field-hash-sha256) | SHA256 hash.type: keyword                                                                                                                                                                                             | extended |
| [hash.sha384](#field-hash-sha384) | SHA384 hash.type: keyword                                                                                                                                                                                             | extended |
| [hash.sha512](#field-hash-sha512) | SHA512 hash.type: keyword                                                                                                                                                                                             | extended |
| [hash.ssdeep](#field-hash-ssdeep) | SSDEEP hash.type: keyword                                                                                                                                                                                             | extended |
| [hash.tlsh](#field-hash-tlsh)     | TLSH hash.type: keyword                                                                                                                                                                                               | extended |


## Field reuse

The `hash` fields are expected to be nested at:
- `dll.hash`
- `email.attachments.file.hash`
- `file.hash`
- `process.hash`

Note also that the `hash` fields are not expected to be used directly at the root of the events.