﻿---
title: Group fields
description: The group fields are meant to represent groups that are relevant to the event. The group fields are expected to be nested at: process.attested_groups,...
url: https://www.elastic.co/docs/reference/ecs/ecs-group
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Group fields
The group fields are meant to represent groups that are relevant to the event.

## Group field details


| Field                               | Description                                                                                                       | Level    |
|-------------------------------------|-------------------------------------------------------------------------------------------------------------------|----------|
| [group.domain](#field-group-domain) | Name of the directory the group is a member of.For example, an LDAP or Active Directory domain name.type: keyword | extended |
| [group.id](#field-group-id)         | Unique identifier for the group on the system/platform.type: keyword                                              | extended |
| [group.name](#field-group-name)     | Name of the group.type: keyword                                                                                   | extended |


## Field reuse

The `group` fields are expected to be nested at:
- `process.attested_groups`
- `process.group`
- `process.real_group`
- `process.saved_group`
- `process.supplemental_groups`
- `user.group`

Note also that the `group` fields may be used directly at the root of the events.