﻿---
title: Geo fields
description: Geo fields can carry data about a specific location related to an event. This geolocation information can be derived from techniques such as Geo IP, or...
url: https://www.elastic.co/docs/reference/ecs/ecs-geo
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Geo fields
Geo fields can carry data about a specific location related to an event.
This geolocation information can be derived from techniques such as Geo IP, or be user-supplied.

## Geo field details


| Field                                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Level    |
|-----------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [geo.city_name](#field-geo-city-name)               | City name.type: keywordexample: `Montreal`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [geo.locality.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-locality-name)                                                                                                                                                                                                                                                                                                                                                                                      | core     |
| [geo.continent_code](#field-geo-continent-code)     | Two-letter code representing continent's name.type: keywordexample: `NA`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [geo.continent.code](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-continent-code)                                                                                                                                                                                                                                                                                                                                                      | core     |
| [geo.continent_name](#field-geo-continent-name)     | Name of the continent.type: keywordexample: `North America`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | core     |
| [geo.country_iso_code](#field-geo-country-iso-code) | Country ISO code.type: keywordexample: `CA`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [geo.country.iso_code](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-country-iso-code)                                                                                                                                                                                                                                                                                                                                                                               | core     |
| [geo.country_name](#field-geo-country-name)         | Country name.type: keywordexample: `Canada`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | core     |
| [geo.location](#field-geo-location)                 | Longitude and latitude.type: geo_pointexample: `{ "lon": -73.614830, "lat": 45.505918 }`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [geo.location.lat](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-location-lat)![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [geo.location.lon](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-location-lon) | core     |
| [geo.name](#field-geo-name)                         | User-defined description of a location, at the level of granularity they care about.Could be the name of their data centers, the floor number, if this describes a local physical entity, city names.Not typically used in automated geolocation.type: keywordexample: `boston-dc`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | extended |
| [geo.postal_code](#field-geo-postal-code)           | Postal code associated with the location.Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.type: keywordexample: `94040`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [geo.postal_code](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-postal-code)                                                                                                                                                                                                                                             | core     |
| [geo.region_iso_code](#field-geo-region-iso-code)   | Region ISO code.type: keywordexample: `CA-QC`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [geo.region.iso_code](https://opentelemetry.io/docs/specs/semconv/attributes-registry/geo/#geo-region-iso-code)                                                                                                                                                                                                                                                                                                                                                                               | core     |
| [geo.region_name](#field-geo-region-name)           | Region name.type: keywordexample: `Quebec`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | core     |
| [geo.timezone](#field-geo-timezone)                 | The time zone of the location, such as IANA time zone name.type: keywordexample: `America/Argentina/Buenos_Aires`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | core     |


## Field reuse

The `geo` fields are expected to be nested at:
- `client.geo`
- `destination.geo`
- `host.geo`
- `observer.geo`
- `server.geo`
- `source.geo`
- `threat.enrichments.indicator.geo`
- `threat.indicator.geo`

Note also that the `geo` fields are not expected to be used directly at the root of the events.