﻿---
title: Gen AI fields
description: Fields that capture the context of Generative Artificial Intelligence (GenAI) Models requests and responses This field group definition is based on the...
url: https://www.elastic.co/docs/reference/ecs/ecs-gen_ai
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Gen AI fields
Fields that capture the context of Generative Artificial Intelligence (GenAI) Models requests and responses
This field group definition is based on the Gen AI namespace of the OpenTelemetry Semantic Conventions ([https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/)).

## Gen AI field details


| Field                                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Level    |
|-----------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [gen_ai.agent.description](#field-gen-ai-agent-description)                 | _This field is beta and subject to change._ Free-form description of the GenAI agent provided by the application.type: keywordexample: `Helps with math problems; Generates fiction stories`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.agent.description](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-agent-description)      | extended |
| [gen_ai.agent.id](#field-gen-ai-agent-id)                                   | _This field is beta and subject to change._ The unique identifier of the GenAI agent.type: keywordexample: `asst_5j66UpCpwteGg4YSxUnt7lPY`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.agent.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-agent-id)                                                                          | extended |
| [gen_ai.agent.name](#field-gen-ai-agent-name)                               | _This field is beta and subject to change._ Human-readable name of the GenAI agent provided by the application.type: keywordexample: `Math Tutor; Fiction Writer`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.agent.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-agent-name)                                               | extended |
| [gen_ai.operation.name](#field-gen-ai-operation-name)                       | _This field is beta and subject to change._ The name of the operation being performed.type: keywordexample: `chat; text_completion; embeddings`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.operation.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-operation-name)                                                         | extended |
| [gen_ai.output.type](#field-gen-ai-output-type)                             | _This field is beta and subject to change._ Represents the content type requested by the client.type: keywordexample: `text; json; image`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.output.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-output-type)                                                                     | extended |
| [gen_ai.request.choice.count](#field-gen-ai-request-choice-count)           | _This field is beta and subject to change._ The target number of candidate completions to return.type: integerexample: `3`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.choice.count](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-choice-count)                                                                  | extended |
| [gen_ai.request.encoding_formats](#field-gen-ai-request-encoding-formats)   | _This field is beta and subject to change._ The encoding formats requested in an embeddings operation, if specified.type: nestedexample: `["float", "binary"]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.encoding_formats](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-encoding-formats)                      | extended |
| [gen_ai.request.frequency_penalty](#field-gen-ai-request-frequency-penalty) | _This field is beta and subject to change._ The frequency penalty setting for the GenAI request.type: doubleexample: `0.1`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.frequency_penalty](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-frequency-penalty)                                                        | extended |
| [gen_ai.request.max_tokens](#field-gen-ai-request-max-tokens)               | _This field is beta and subject to change._ The maximum number of tokens the model generates for a request.type: integerexample: `100`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.max_tokens](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-max-tokens)                                                          | extended |
| [gen_ai.request.model](#field-gen-ai-request-model)                         | _This field is beta and subject to change._ The name of the GenAI model a request is being made to.type: keywordexample: `gpt-4`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.model](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-model)                                                                          | extended |
| [gen_ai.request.presence_penalty](#field-gen-ai-request-presence-penalty)   | _This field is beta and subject to change._ The presence penalty setting for the GenAI request.type: doubleexample: `0.1`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.presence_penalty](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-presence-penalty)                                                           | extended |
| [gen_ai.request.seed](#field-gen-ai-request-seed)                           | _This field is beta and subject to change._ Requests with same seed value more likely to return same result.type: integerexample: `100`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.seed](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-seed)                                                                     | extended |
| [gen_ai.request.stop_sequences](#field-gen-ai-request-stop-sequences)       | _This field is beta and subject to change._ List of sequences that the model will use to stop generating further tokens.type: nestedexample: `["forest", "lived"]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.stop_sequences](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-stop-sequences)                      | extended |
| [gen_ai.request.temperature](#field-gen-ai-request-temperature)             | _This field is beta and subject to change._ The temperature setting for the GenAI request.type: doubleexample: `0.0`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.temperature](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-temperature)                                                                          | extended |
| [gen_ai.request.top_k](#field-gen-ai-request-top-k)                         | _This field is beta and subject to change._ The top_k sampling setting for the GenAI request.type: doubleexample: `1.0`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.top_k](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-top-k)                                                                                   | extended |
| [gen_ai.request.top_p](#field-gen-ai-request-top-p)                         | _This field is beta and subject to change._ The top_p sampling setting for the GenAI request.type: doubleexample: `1.0`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.request.top_p](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-request-top-p)                                                                                   | extended |
| [gen_ai.response.finish_reasons](#field-gen-ai-response-finish-reasons)     | _This field is beta and subject to change._ Array of reasons the model stopped generating tokens, corresponding to each generation received.type: nestedexample: `["stop", "length"]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.response.finish_reasons](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-response-finish-reasons) | extended |
| [gen_ai.response.id](#field-gen-ai-response-id)                             | _This field is beta and subject to change._ The unique identifier for the completion.type: keywordexample: `chatcmpl-123`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.response.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-response-id)                                                                                     | extended |
| [gen_ai.response.model](#field-gen-ai-response-model)                       | _This field is beta and subject to change._ The name of the model that generated the response.type: keywordexample: `gpt-4-0613`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.response.model](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-response-model)                                                                        | extended |
| [gen_ai.system](#field-gen-ai-system)                                       | _This field is beta and subject to change._ The Generative AI product as identified by the client or server instrumentation.type: keywordexample: `openai`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.provider.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-provider-name)                                      | extended |
| [gen_ai.token.type](#field-gen-ai-token-type)                               | _This field is beta and subject to change._ The type of token being counted.type: keywordexample: `input; output`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.token.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-token-type)                                                                                               | extended |
| [gen_ai.tool.call.id](#field-gen-ai-tool-call-id)                           | _This field is beta and subject to change._ The tool call identifier.type: keywordexample: `call_mszuSIzqtI65i1wAUOE8w5H4`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.tool.call.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-tool-call-id)                                                                                  | extended |
| [gen_ai.tool.name](#field-gen-ai-tool-name)                                 | _This field is beta and subject to change._ Name of the tool utilized by the agent.type: keywordexample: `Flights`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.tool.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-tool-name)                                                                                                | extended |
| [gen_ai.tool.type](#field-gen-ai-tool-type)                                 | _This field is beta and subject to change._ Type of the tool utilized by the agenttype: keywordexample: `function; extension; datastore`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.tool.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-tool-type)                                                                          | extended |
| [gen_ai.usage.input_tokens](#field-gen-ai-usage-input-tokens)               | _This field is beta and subject to change._ The number of tokens used in the GenAI input (prompt).type: integerexample: `100`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.usage.input_tokens](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-usage-input-tokens)                                                                   | extended |
| [gen_ai.usage.output_tokens](#field-gen-ai-usage-output-tokens)             | _This field is beta and subject to change._ The number of tokens used in the GenAI response (completion).type: integerexample: `180`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [gen_ai.usage.output_tokens](https://opentelemetry.io/docs/specs/semconv/attributes-registry/gen-ai/#gen-ai-usage-output-tokens)                                                          | extended |