﻿---
title: File fields
description: A file is defined as a set of information that has been created on, or has existed on a filesystem. File objects can be associated with host events, network...
url: https://www.elastic.co/docs/reference/ecs/ecs-file
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# File fields
A file is defined as a set of information that has been created on, or has existed on a filesystem.
File objects can be associated with host events, network events, and/or file events (e.g., those produced by File Integrity Monitoring [FIM] products or services). File fields provide details about the affected file associated with the event or metric.

## File field details


| Field                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Level    |
|-------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [file.accessed](#field-file-accessed)                       | Last time the file was accessed.Note that not all filesystems keep track of access time.type: date![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.accessed](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-accessed)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [file.attributes](#field-file-attributes)                   | Array of file attributes.Attributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write.type: keywordNote: This field should contain an array of values.example: `["readonly", "system"]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.attributes](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-attributes)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [file.created](#field-file-created)                         | File creation time.Note that not all filesystems store the creation time.type: date![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.created](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-created)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [file.ctime](#field-file-ctime)                             | Last time the file attributes or metadata changed.Note that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file.type: date![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.changed](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-changed)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [file.device](#field-file-device)                           | Device that is the source of the file.type: keywordexample: `sda`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [file.directory](#field-file-directory)                     | Directory where the file is located. It should include the drive letter, when appropriate.type: keywordexample: `/home/alice`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.directory](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-directory)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [file.drive_letter](#field-file-drive-letter)               | Drive letter where the file is located. This field is only relevant on Windows.The value should be uppercase, and not include the colon.type: keywordexample: `C`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [file.extension](#field-file-extension)                     | File extension, excluding the leading dot.Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").type: keywordexample: `png`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.extension](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-extension)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [file.fork_name](#field-file-fork-name)                     | A fork is additional data associated with a filesystem object.On Linux, a resource fork is used to store additional data with a filesystem object. A file always has at least one fork for the data portion, and additional forks may exist.On NTFS, this is analogous to an Alternate Data Stream (ADS), and the default data stream for a file is just called $DATA. Zone.Identifier is commonly used by Windows to track contents downloaded from the Internet. An ADS is typically of the form: `C:\path\to\filename.extension:some_fork_name`, and `some_fork_name` is the value that should populate `fork_name`. `filename.extension` should populate `file.name`, and `extension` should populate `file.extension`. The full path, `file.path`, will include the fork name.type: keywordexample: `Zone.Identifer`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.fork_name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-fork-name) | extended |
| [file.gid](#field-file-gid)                                 | Primary group ID (GID) of the file.type: keywordexample: `1001`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.group.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-group-id)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [file.group](#field-file-group)                             | Primary group name of the file.type: keywordexample: `alice`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.group.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-group-name)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [file.inode](#field-file-inode)                             | Inode representing the file in the filesystem.type: keywordexample: `256383`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.inode](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-inode)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | extended |
| [file.mime_type](#field-file-mime-type)                     | MIME type should identify the format of the file or stream of bytes using IANA official types: [https://www.iana.org/assignments/media-types/media-types.xhtml](https://www.iana.org/assignments/media-types/media-types.xhtml), where possible. When more than one type is applicable, the most specific type should be used.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | extended |
| [file.mode](#field-file-mode)                               | Mode of the file in octal representation.type: keywordexample: `0640`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.mode](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-mode)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [file.mtime](#field-file-mtime)                             | Last time the file content was modified.type: date![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.modified](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-modified)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [file.name](#field-file-name)                               | Name of the file including the extension, without the directory.type: keywordexample: `example.png`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-name)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [file.origin_referrer_url](#field-file-origin-referrer-url) | _This field is beta and subject to change._ The URL of the webpage that linked to the file.type: keywordexample: `http://example.com/article1.html`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [file.origin_url](#field-file-origin-url)                   | _This field is beta and subject to change._ The URL where the file is hosted.type: keywordexample: `http://example.com/imgs/article1_img1.jpg`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [file.owner](#field-file-owner)                             | File owner's username.type: keywordexample: `alice`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.owner.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-owner-name)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [file.path](#field-file-path)                               | Full path to the file, including the file name. It should include the drive letter, when appropriate.type: keywordMulti-fields:* file.path.text (type: match_only_text)example: `/home/alice/example.png`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.path](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-path)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [file.size](#field-file-size)                               | File size in bytes.Only relevant when `file.type` is "file".type: longexample: `16384`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.size](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-size)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [file.target_path](#field-file-target-path)                 | Target path for symlinks.type: keywordMulti-fields:* file.target_path.text (type: match_only_text)![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.symbolic_link.target_path](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-symbolic-link-target-path)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [file.type](#field-file-type)                               | File type (file, dir, or symlink).type: keywordexample: `file`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [file.uid](#field-file-uid)                                 | The user ID (UID) or security identifier (SID) of the file owner.type: keywordexample: `1001`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [file.owner.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/file/#file-owner-id)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | extended |


## Field reuse

The `file` fields are expected to be nested at:
- `threat.enrichments.indicator.file`
- `threat.indicator.file`

Note also that the `file` fields may be used directly at the root of the events.

### Field sets that can be nested under File


| Location                | Field Set                                                                      | Description                                                                                                              |
|-------------------------|--------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------|
| `file.code_signature.*` | [code_signature](https://www.elastic.co/docs/reference/ecs/ecs-code_signature) | These fields contain information about binary code signatures.                                                           |
| `file.elf.*`            | [elf](https://www.elastic.co/docs/reference/ecs/ecs-elf)                       | These fields contain Linux Executable Linkable Format (ELF) metadata.                                                    |
| `file.hash.*`           | [hash](https://www.elastic.co/docs/reference/ecs/ecs-hash)                     | Hashes, usually file hashes.                                                                                             |
| `file.macho.*`          | [macho](https://www.elastic.co/docs/reference/ecs/ecs-macho)                   | _This field reuse is beta and subject to change._ These fields contain Mac OS Mach Object file format (Mach-O) metadata. |
| `file.pe.*`             | [pe](https://www.elastic.co/docs/reference/ecs/ecs-pe)                         | These fields contain Windows Portable Executable (PE) metadata.                                                          |
| `file.x509.*`           | [x509](https://www.elastic.co/docs/reference/ecs/ecs-x509)                     | These fields contain x509 certificate metadata.                                                                          |