﻿---
title: ECS field reference
description: This is the documentation of ECS version 9.3.0. ECS defines multiple groups of related fields. They are called "field sets". The Base field set is the...
url: https://www.elastic.co/docs/reference/ecs/ecs-field-reference
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ECS field reference
This is the documentation of ECS version 9.3.0.
ECS defines multiple groups of related fields. They are called "field sets". The [Base](https://www.elastic.co/docs/reference/ecs/ecs-base) field set is the only one whose fields are defined at the root of the event.
All other field sets are defined as objects in Elasticsearch, under which all fields are defined.
For a single page representation of all fields, please see the [generated CSV of fields](https://github.com/elastic/ecs/blob/master/generated/csv/fields.csv).

## Field sets


| Field Set                                                                      | Description                                                                              |
|--------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|
| [Base](https://www.elastic.co/docs/reference/ecs/ecs-base)                     | All fields defined directly at the root of the events.                                   |
| [Agent](https://www.elastic.co/docs/reference/ecs/ecs-agent)                   | Fields about the monitoring agent.                                                       |
| [Autonomous System](https://www.elastic.co/docs/reference/ecs/ecs-as)          | Fields describing an Autonomous System (Internet routing prefix).                        |
| [Client](https://www.elastic.co/docs/reference/ecs/ecs-client)                 | Fields about the client side of a network connection, used with server.                  |
| [Cloud](https://www.elastic.co/docs/reference/ecs/ecs-cloud)                   | Fields about the cloud resource.                                                         |
| [Code Signature](https://www.elastic.co/docs/reference/ecs/ecs-code_signature) | These fields contain information about binary code signatures.                           |
| [Container](https://www.elastic.co/docs/reference/ecs/ecs-container)           | Fields describing the container that generated this event.                               |
| [Data Stream](https://www.elastic.co/docs/reference/ecs/ecs-data_stream)       | The data_stream fields take part in defining the new data stream naming scheme.          |
| [Destination](https://www.elastic.co/docs/reference/ecs/ecs-destination)       | Fields about the destination side of a network connection, used with source.             |
| [Device](https://www.elastic.co/docs/reference/ecs/ecs-device)                 | Fields characterizing a (mobile) device a process or application is running on.          |
| [DLL](https://www.elastic.co/docs/reference/ecs/ecs-dll)                       | These fields contain information about code libraries dynamically loaded into processes. |
| [DNS](https://www.elastic.co/docs/reference/ecs/ecs-dns)                       | Fields describing DNS queries and answers.                                               |
| [ECS](https://www.elastic.co/docs/reference/ecs/ecs-ecs)                       | Meta-information specific to ECS.                                                        |
| [ELF Header](https://www.elastic.co/docs/reference/ecs/ecs-elf)                | These fields contain Linux Executable Linkable Format (ELF) metadata.                    |
| [Email](https://www.elastic.co/docs/reference/ecs/ecs-email)                   | Describes an email transaction.                                                          |
| [Entity](https://www.elastic.co/docs/reference/ecs/ecs-entity)                 | Fields to describe various types of entities across IT environments.                     |
| [Error](https://www.elastic.co/docs/reference/ecs/ecs-error)                   | Fields about errors of any kind.                                                         |
| [Event](https://www.elastic.co/docs/reference/ecs/ecs-event)                   | Fields breaking down the event details.                                                  |
| [FaaS](https://www.elastic.co/docs/reference/ecs/ecs-faas)                     | Fields describing functions as a service.                                                |
| [File](https://www.elastic.co/docs/reference/ecs/ecs-file)                     | Fields describing files.                                                                 |
| [Gen AI](https://www.elastic.co/docs/reference/ecs/ecs-gen_ai)                 | Fields on Generative Artificial Intelligence (GenAI) Models requests and responses       |
| [Geo](https://www.elastic.co/docs/reference/ecs/ecs-geo)                       | Fields describing a location.                                                            |
| [Group](https://www.elastic.co/docs/reference/ecs/ecs-group)                   | User's group relevant to the event.                                                      |
| [Hash](https://www.elastic.co/docs/reference/ecs/ecs-hash)                     | Hashes, usually file hashes.                                                             |
| [Host](https://www.elastic.co/docs/reference/ecs/ecs-host)                     | Fields describing the relevant computing instance.                                       |
| [HTTP](https://www.elastic.co/docs/reference/ecs/ecs-http)                     | Fields describing an HTTP request.                                                       |
| [Interface](https://www.elastic.co/docs/reference/ecs/ecs-interface)           | Fields to describe observer interface information.                                       |
| [Log](https://www.elastic.co/docs/reference/ecs/ecs-log)                       | Details about the event's logging mechanism.                                             |
| [Mach-O Header](https://www.elastic.co/docs/reference/ecs/ecs-macho)           | These fields contain Mac OS Mach Object file format (Mach-O) metadata.                   |
| [Network](https://www.elastic.co/docs/reference/ecs/ecs-network)               | Fields describing the communication path over which the event happened.                  |
| [Observer](https://www.elastic.co/docs/reference/ecs/ecs-observer)             | Fields describing an entity observing the event from outside the host.                   |
| [Orchestrator](https://www.elastic.co/docs/reference/ecs/ecs-orchestrator)     | Fields relevant to container orchestrators.                                              |
| [Organization](https://www.elastic.co/docs/reference/ecs/ecs-organization)     | Fields describing the organization or company the event is associated with.              |
| [Operating System](https://www.elastic.co/docs/reference/ecs/ecs-os)           | OS fields contain information about the operating system.                                |
| [Package](https://www.elastic.co/docs/reference/ecs/ecs-package)               | These fields contain information about an installed software package.                    |
| [PE Header](https://www.elastic.co/docs/reference/ecs/ecs-pe)                  | These fields contain Windows Portable Executable (PE) metadata.                          |
| [Process](https://www.elastic.co/docs/reference/ecs/ecs-process)               | These fields contain information about a process.                                        |
| [Registry](https://www.elastic.co/docs/reference/ecs/ecs-registry)             | Fields related to Windows Registry operations.                                           |
| [Related](https://www.elastic.co/docs/reference/ecs/ecs-related)               | Fields meant to facilitate pivoting around a piece of data.                              |
| [Risk information](https://www.elastic.co/docs/reference/ecs/ecs-risk)         | Fields for describing risk score and level.                                              |
| [Rule](https://www.elastic.co/docs/reference/ecs/ecs-rule)                     | Fields to capture details about rules used to generate alerts or other notable events.   |
| [Server](https://www.elastic.co/docs/reference/ecs/ecs-server)                 | Fields about the server side of a network connection, used with client.                  |
| [Service](https://www.elastic.co/docs/reference/ecs/ecs-service)               | Fields describing the service for or from which the data was collected.                  |
| [Source](https://www.elastic.co/docs/reference/ecs/ecs-source)                 | Fields about the source side of a network connection, used with destination.             |
| [Threat](https://www.elastic.co/docs/reference/ecs/ecs-threat)                 | Fields to classify events and alerts according to a threat taxonomy.                     |
| [TLS](https://www.elastic.co/docs/reference/ecs/ecs-tls)                       | Fields describing a TLS connection.                                                      |
| [Tracing](https://www.elastic.co/docs/reference/ecs/ecs-tracing)               | Fields related to distributed tracing.                                                   |
| [URL](https://www.elastic.co/docs/reference/ecs/ecs-url)                       | Fields that let you store URLs in various forms.                                         |
| [User](https://www.elastic.co/docs/reference/ecs/ecs-user)                     | Fields to describe the user relevant to the event.                                       |
| [User agent](https://www.elastic.co/docs/reference/ecs/ecs-user_agent)         | Fields to describe a browser user_agent string.                                          |
| [VLAN](https://www.elastic.co/docs/reference/ecs/ecs-vlan)                     | Fields to describe observed VLAN information.                                            |
| [Volume](https://www.elastic.co/docs/reference/ecs/ecs-volume)                 | Fields related to storage volume details.                                                |
| [Vulnerability](https://www.elastic.co/docs/reference/ecs/ecs-vulnerability)   | Fields to describe the vulnerability relevant to an event.                               |
| [x509 Certificate](https://www.elastic.co/docs/reference/ecs/ecs-x509)         | These fields contain x509 certificate metadata.                                          |