﻿---
title: FaaS fields
description: The user fields describe information about the function as a service (FaaS) that is relevant to the event. 
url: https://www.elastic.co/docs/reference/ecs/ecs-faas
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# FaaS fields
The user fields describe information about the function as a service (FaaS) that is relevant to the event.

## FaaS field details


| Field                                                     | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Level    |
|-----------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [faas.coldstart](#field-faas-coldstart)                   | Boolean value indicating a cold start of a function.type: boolean![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [faas.coldstart](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas/#faas-coldstart)                                                                                          | extended |
| [faas.execution](#field-faas-execution)                   | The execution ID of the current function execution.type: keywordexample: `af9d5aa4-a685-4c5f-a22b-444f80b3cc28`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [faas.invocation_id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas/#faas-invocation-id)                          | extended |
| [faas.id](#field-faas-id)                                 | The unique identifier of a serverless function.For AWS Lambda it's the function ARN (Amazon Resource Name) without a version or alias suffix.type: keywordexample: `arn:aws:lambda:us-west-2:123456789012:function:my-function`                                                                                                                                                                                                                                                                    | extended |
| [faas.name](#field-faas-name)                             | The name of a serverless function.type: keywordexample: `my-function`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [faas.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas/#faas-name)                                                                                                | extended |
| [faas.trigger.request_id](#field-faas-trigger-request-id) | The ID of the trigger request , message, event, etc.type: keywordexample: `123456789`                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [faas.trigger.type](#field-faas-trigger-type)             | The trigger for the function execution.Expected values for this field:* `http`* `pubsub`* `datasource`* `timer`* `other`type: keywordexample: `http`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [faas.trigger](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas/#faas-trigger) | extended |
| [faas.version](#field-faas-version)                       | The version of a serverless function.type: keywordexample: `123`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [faas.version](https://opentelemetry.io/docs/specs/semconv/attributes-registry/faas/#faas-version)                                                                                               | extended |