﻿---
title: Error fields
description: These fields can represent errors of any kind. Use them for errors that happen while fetching events or in cases where the event itself contains an error...
url: https://www.elastic.co/docs/reference/ecs/ecs-error
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Error fields
These fields can represent errors of any kind.
Use them for errors that happen while fetching events or in cases where the event itself contains an error.

## Error field details


| Field                                         | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Level    |
|-----------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [error.code](#field-error-code)               | Error code describing the error.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                              | core     |
| [error.id](#field-error-id)                   | Unique identifier for the error.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                              | core     |
| [error.message](#field-error-message)         | Error message.type: match_only_text![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [exception.message](https://opentelemetry.io/docs/specs/semconv/attributes-registry/exception/#exception-message)                                                                                           | core     |
| [error.stack_trace](#field-error-stack-trace) | The stack trace of this error in plain text.type: wildcardMulti-fields:* error.stack_trace.text (type: match_only_text)![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [exception.stacktrace](https://opentelemetry.io/docs/specs/semconv/attributes-registry/exception/#exception-stacktrace) | extended |
| [error.type](#field-error-type)               | The type of the error, for example the class name of the exception.type: keywordexample: `java.lang.NullPointerException`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [error.type](https://opentelemetry.io/docs/specs/semconv/attributes-registry/error/#error-type)                                 | extended |