﻿---
title: Entity fields
description: The entity fields provide a standardized way to represent and categorize different types of components within an IT environment, including those that...
url: https://www.elastic.co/docs/reference/ecs/ecs-entity
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Entity fields
The entity fields provide a standardized way to represent and categorize different types of components within an IT environment, including those that don't have dedicated field sets in ECS. An entity represents a discrete, identifiable component that can be described by a set of attributes and maintains its identity over time.

## Entity field details


| Field                                                           | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Level    |
|-----------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [entity.attributes](#field-entity-attributes)                   | _This field is beta and subject to change._ A set of static or semi-static attributes of the entity. Usually boolean or keyword field data types. Use this field set when you need to track static or semi-static characteristics of an entity for advanced searching and correlation of normalized values across different providers/sources and entity types.type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [entity.behavior](#field-entity-behavior)                       | _This field is beta and subject to change._ A set of ephemeral characteristics of the entity, derived from observed behaviors during a specific time period. Usually boolean field data type. Use this field set when you need to capture and track ephemeral characteristics of an entity for advanced searching, correlation of normalized values across different providers/sources and entity types.type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [entity.display_name](#field-entity-display-name)               | _This field is beta and subject to change._ An optional field used when a pretty name is desired for entity-centric operations. This field should not be used for correlation with `*.name` fields for entities with dedicated field sets (e.g., `host`).type: keywordMulti-fields:* entity.display_name.text (type: match_only_text)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | extended |
| [entity.id](#field-entity-id)                                   | A unique identifier for the entity. When multiple identifiers exist, this should be the most stable and commonly used identifier that: 1) persists across the entity's lifecycle, 2) ensures uniqueness within its scope, 3) is commonly used for queries and correlation, and 4) is readily available in most observations (logs/events). For entities with dedicated field sets (e.g., host, user), this value should match the corresponding *.id field. Alternative identifiers (e.g., ARNs values in AWS, URLs) can be preserved in the raw field.type: keyword                                                                                                                                                                                                                                                                                                                                                                        | core     |
| [entity.last_seen_timestamp](#field-entity-last-seen-timestamp) | _This field is beta and subject to change._ Indicates the date/time when this entity was last "seen," usually based upon the last event/log that is initiated by this entity.type: date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | extended |
| [entity.lifecycle](#field-entity-lifecycle)                     | _This field is beta and subject to change._ A set of temporal characteristics of the entity. Usually date field data type. Use this field set when you need to track temporal characteristics of an entity for advanced searching and correlation of normalized values across different providers/sources and entity types.type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | extended |
| [entity.metrics](#field-entity-metrics)                         | _This field is beta and subject to change._ Field set for any fields containing numeric entity metrics. These use dynamic field data type mapping.type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [entity.name](#field-entity-name)                               | _This field is beta and subject to change._ The name of the entity. The keyword field enables exact matches for filtering and aggregations, while the text field enables full-text search. For entities with dedicated field sets (e.g., `host`), this field should mirrors the corresponding *.name value.type: keywordMulti-fields:* entity.name.text (type: match_only_text)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | core     |
| [entity.raw](#field-entity-raw)                                 | _This field is beta and subject to change._ Original, unmodified fields from the source system. Usually flattened field data type. While the attributes field should be used for normalized fields requiring advanced queries, this field preserves all source metadata with basic search capabilities.type: object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | extended |
| [entity.reference](#field-entity-reference)                     | _This field is beta and subject to change._ A URI, URL, or other direct reference to access or locate the entity in its source system. This could be an API endpoint, web console URL, or other addressable location. Format may vary by entity type and source system.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [entity.source](#field-entity-source)                           | _This field is beta and subject to change._ The module or integration that provided this entity data (similar to event.module).type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | core     |
| [entity.sub_type](#field-entity-sub-type)                       | _This field is beta and subject to change._ The specific type designation for the entity as defined by its provider or system. This field provides more granular classification than the type field. Examples: `aws_s3_bucket`, `gcp_cloud_storage_bucket`, `azure_blob_container` would all map to entity type `bucket`.  `hardware` , `virtual` , `container` , `node` , `cloud_instance` would all map to entity type `host`.type: keywordexample: `aws_s3_bucket`                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | extended |
| [entity.type](#field-entity-type)                               | _This field is beta and subject to change._ A standardized high-level classification of the entity. This provides a normalized way to group similar entities across different providers or systems. Example values: `bucket`, `database`, `container`, `function`, `queue`, `host`, `user`, `application`, `session`, `cloud`, `orchestrator`, etc. If an entity is nested under a top-level namespace like `host` or `cloud`, or similar, its type array should include the matching value — for example, `host` or `cloud`.type: keywordNote: This field should contain an array of values.**Important:** The field value must be one of the following:bucket, database, container, function, queue, host, user, application, service, session, cloud, orchestratorTo learn more about when to use which value, visit the page [allowed values for entity.type](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-entity-type) | core     |


## Field reuse

The `entity` fields are expected to be nested at:
- `cloud.entity`
- `entity.target`
- `host.entity`
- `orchestrator.entity`
- `service.entity`
- `user.entity`

Note also that the `entity` fields may be used directly at the root of the events.

### Field sets that can be nested under Entity


| Location          | Field Set                                                      | Description                      |
|-------------------|----------------------------------------------------------------|----------------------------------|
| `entity.target.*` | [entity](https://www.elastic.co/docs/reference/ecs/ecs-entity) | Targeted entity of action taken. |