﻿---
title: Email fields
description: Event details relating to an email transaction. This field set focuses on the email message header, body, and attachments. Network protocols that send...
url: https://www.elastic.co/docs/reference/ecs/ecs-email
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Email fields
Event details relating to an email transaction.
This field set focuses on the email message header, body, and attachments. Network protocols that send and receive email messages such as SMTP are outside the scope of the `email.*` fields.

## Email field details


| Field                                                                       | Description                                                                                                                                                                                             | Level    |
|-----------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [email.attachments](#field-email-attachments)                               | A list of objects describing the attachment files sent along with an email message.type: nestedNote: This field should contain an array of values.                                                      | extended |
| [email.attachments.file.extension](#field-email-attachments-file-extension) | Attachment file extension, excluding the leading dot.type: keywordexample: `txt`                                                                                                                        | extended |
| [email.attachments.file.mime_type](#field-email-attachments-file-mime-type) | The MIME media type of the attachment.This value will typically be extracted from the `Content-Type` MIME header field.type: keywordexample: `text/plain`                                               | extended |
| [email.attachments.file.name](#field-email-attachments-file-name)           | Name of the attachment file including the file extension.type: keywordexample: `attachment.txt`                                                                                                         | extended |
| [email.attachments.file.size](#field-email-attachments-file-size)           | Attachment file size in bytes.type: longexample: `64329`                                                                                                                                                | extended |
| [email.bcc.address](#field-email-bcc-address)                               | The email address of BCC recipienttype: keywordNote: This field should contain an array of values.example: `bcc.user1@example.com`                                                                      | extended |
| [email.cc.address](#field-email-cc-address)                                 | The email address of CC recipienttype: keywordNote: This field should contain an array of values.example: `cc.user1@example.com`                                                                        | extended |
| [email.content_type](#field-email-content-type)                             | Information about how the message is to be displayed.Typically a MIME type.type: keywordexample: `text/plain`                                                                                           | extended |
| [email.delivery_timestamp](#field-email-delivery-timestamp)                 | The date and time when the email message was received by the service or client.type: dateexample: `2020-11-10T22:12:34.8196921Z`                                                                        | extended |
| [email.direction](#field-email-direction)                                   | The direction of the message based on the sending and receiving domains.type: keywordexample: `inbound`                                                                                                 | extended |
| [email.from.address](#field-email-from-address)                             | The email address of the sender, typically from the RFC 5322 `From:` header field.type: keywordNote: This field should contain an array of values.example: `sender@example.com`                         | extended |
| [email.local_id](#field-email-local-id)                                     | Unique identifier given to the email by the source that created the event.Identifier is not persistent across hops.type: keywordexample: `c26dbea0-80d5-463b-b93c-4e8b708219ce`                         | extended |
| [email.message_id](#field-email-message-id)                                 | Identifier from the RFC 5322 `Message-ID:` email header that refers to a particular email message.type: wildcardexample: `81ce15$8r2j59@mail01.example.com`                                             | extended |
| [email.origination_timestamp](#field-email-origination-timestamp)           | The date and time the email message was composed. Many email clients will fill in this value automatically when the message is sent by a user.type: dateexample: `2020-11-10T22:12:34.8196921Z`         | extended |
| [email.reply_to.address](#field-email-reply-to-address)                     | The address that replies should be delivered to based on the value in the RFC 5322 `Reply-To:` header.type: keywordNote: This field should contain an array of values.example: `reply.here@example.com` | extended |
| [email.sender.address](#field-email-sender-address)                         | Per RFC 5322, specifies the address responsible for the actual transmission of the message.type: keyword                                                                                                | extended |
| [email.subject](#field-email-subject)                                       | A brief summary of the topic of the message.type: keywordMulti-fields:* email.subject.text (type: match_only_text)example: `Please see this important message.`                                         | extended |
| [email.to.address](#field-email-to-address)                                 | The email address of recipienttype: keywordNote: This field should contain an array of values.example: `user1@example.com`                                                                              | extended |
| [email.x_mailer](#field-email-x-mailer)                                     | The name of the application that was used to draft and send the original email message.type: keywordexample: `Spambot v2.5`                                                                             | extended |


### Field sets that can be nested under Email


| Location                        | Field Set                                                  | Description                  |
|---------------------------------|------------------------------------------------------------|------------------------------|
| `email.attachments.file.hash.*` | [hash](https://www.elastic.co/docs/reference/ecs/ecs-hash) | Hashes, usually file hashes. |