﻿---
title: ELF Header fields
description: These fields contain Linux Executable Linkable Format (ELF) metadata. The elf fields are expected to be nested at: file.elf, process.elf. Note also that...
url: https://www.elastic.co/docs/reference/ecs/ecs-elf
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ELF Header fields
These fields contain Linux Executable Linkable Format (ELF) metadata.

## ELF Header field details


| Field                                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Level    |
|-----------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [elf.architecture](#field-elf-architecture)                                 | Machine architecture of the ELF file.type: keywordexample: `x86-64`                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [elf.byte_order](#field-elf-byte-order)                                     | Byte sequence of ELF file.type: keywordexample: `Little Endian`                                                                                                                                                                                                                                                                                                                                                                                                                                                      | extended |
| [elf.cpu_type](#field-elf-cpu-type)                                         | CPU type of the ELF file.type: keywordexample: `Intel`                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [elf.creation_date](#field-elf-creation-date)                               | Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.type: date                                                                                                                                                                                                                                                                                                                                                                       | extended |
| [elf.exports](#field-elf-exports)                                           | List of exported element names and types.type: flattenedNote: This field should contain an array of values.                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [elf.go_import_hash](#field-elf-go-import-hash)                             | A hash of the Go language imports in an ELF file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.The algorithm used to calculate the Go symbol hash and a reference implementation are available here: [https://github.com/elastic/toutoumomoma](https://github.com/elastic/toutoumomoma)type: keywordexample: `10bddcb4cee42080f76c88d9ff964491` | extended |
| [elf.go_imports](#field-elf-go-imports)                                     | List of imported Go language element names and types.type: flattened                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [elf.go_imports_names_entropy](#field-elf-go-imports-names-entropy)         | Shannon entropy calculation from the list of Go imports.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [elf.go_imports_names_var_entropy](#field-elf-go-imports-names-var-entropy) | Variance for Shannon entropy calculation from the list of Go imports.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                      | extended |
| [elf.go_stripped](#field-elf-go-stripped)                                   | Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.type: boolean                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [elf.header.abi_version](#field-elf-header-abi-version)                     | Version of the ELF Application Binary Interface (ABI).type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [elf.header.class](#field-elf-header-class)                                 | Header class of the ELF file.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [elf.header.data](#field-elf-header-data)                                   | Data table of the ELF header.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [elf.header.entrypoint](#field-elf-header-entrypoint)                       | Header entrypoint of the ELF file.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | extended |
| [elf.header.object_version](#field-elf-header-object-version)               | "0x1" for original ELF files.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [elf.header.os_abi](#field-elf-header-os-abi)                               | Application Binary Interface (ABI) of the Linux OS.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                     | extended |
| [elf.header.type](#field-elf-header-type)                                   | Header type of the ELF file.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | extended |
| [elf.header.version](#field-elf-header-version)                             | Version of the ELF header.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [elf.import_hash](#field-elf-import-hash)                                   | A hash of the imports in an ELF file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.This is an ELF implementation of the Windows PE imphash.type: keywordexample: `d41d8cd98f00b204e9800998ecf8427e`                                                                                                                                                                                | extended |
| [elf.imports](#field-elf-imports)                                           | List of imported element names and types.type: flattenedNote: This field should contain an array of values.                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [elf.imports_names_entropy](#field-elf-imports-names-entropy)               | Shannon entropy calculation from the list of imported element names and types.type: long                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [elf.imports_names_var_entropy](#field-elf-imports-names-var-entropy)       | Variance for Shannon entropy calculation from the list of imported element names and types.type: long                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [elf.sections](#field-elf-sections)                                         | An array containing an object for each section of the ELF file.The keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.type: nestedNote: This field should contain an array of values.                                                                                                                                                                                                                                                                                | extended |
| [elf.sections.chi2](#field-elf-sections-chi2)                               | Chi-square probability distribution of the section.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [elf.sections.entropy](#field-elf-sections-entropy)                         | Shannon entropy calculation from the section.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [elf.sections.flags](#field-elf-sections-flags)                             | ELF Section List flags.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [elf.sections.name](#field-elf-sections-name)                               | ELF Section List name.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [elf.sections.physical_offset](#field-elf-sections-physical-offset)         | ELF Section List offset.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [elf.sections.physical_size](#field-elf-sections-physical-size)             | ELF Section List physical size.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | extended |
| [elf.sections.type](#field-elf-sections-type)                               | ELF Section List type.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [elf.sections.var_entropy](#field-elf-sections-var-entropy)                 | Variance for Shannon entropy calculation from the section.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [elf.sections.virtual_address](#field-elf-sections-virtual-address)         | ELF Section List virtual address.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [elf.sections.virtual_size](#field-elf-sections-virtual-size)               | ELF Section List virtual size.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [elf.segments](#field-elf-segments)                                         | An array containing an object for each segment of the ELF file.The keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.type: nestedNote: This field should contain an array of values.                                                                                                                                                                                                                                                                                | extended |
| [elf.segments.sections](#field-elf-segments-sections)                       | ELF object segment sections.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | extended |
| [elf.segments.type](#field-elf-segments-type)                               | ELF object segment type.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [elf.shared_libraries](#field-elf-shared-libraries)                         | List of shared libraries used by this ELF object.type: keywordNote: This field should contain an array of values.                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [elf.telfhash](#field-elf-telfhash)                                         | telfhash symbol hash for ELF file.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | extended |


## Field reuse

The `elf` fields are expected to be nested at:
- `file.elf`
- `process.elf`

Note also that the `elf` fields are not expected to be used directly at the root of the events.