﻿---
title: DNS fields
description: Fields describing DNS queries and answers. DNS events should either represent a single DNS query prior to getting answers (dns.type:query) or they should...
url: https://www.elastic.co/docs/reference/ecs/ecs-dns
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# DNS fields
Fields describing DNS queries and answers.
DNS events should either represent a single DNS query prior to getting answers (`dns.type:query`) or they should represent a full exchange and contain the query details as well as all of the answers that were provided for this query (`dns.type:answer`).

## DNS field details


| Field                                                                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Level    |
|-------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [dns.answers](#field-dns-answers)                                       | An array containing an object for each answer section returned by the server.The main keys that should be present in these objects are defined by ECS. Records that have more information may contain more keys than what ECS defines.Not all DNS data sources give all details about DNS answers. At minimum, answer objects must contain the `data` key. If more information is available, map as much of it to ECS as possible, and add any additional fields to the answer objects as custom fields.type: objectNote: This field should contain an array of values.![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [dns.answers](https://opentelemetry.io/docs/specs/semconv/attributes-registry/dns/#dns-answers) | extended |
| [dns.answers.class](#field-dns-answers-class)                           | The class of DNS data contained in this resource record.type: keywordexample: `IN`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [dns.answers.data](#field-dns-answers-data)                             | The data describing the resource.The meaning of this data depends on the type and class of the resource record.type: keywordexample: `10.10.10.10`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [dns.answers.name](#field-dns-answers-name)                             | The domain name to which this resource record pertains.If a chain of CNAME is being resolved, each answer's `name` should be the one that corresponds with the answer's `data`. It should not simply be the original `question.name` repeated.type: keywordexample: `www.example.com`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [dns.answers.ttl](#field-dns-answers-ttl)                               | The time interval in seconds that this resource record may be cached before it should be discarded. Zero values mean that the data should not be cached.type: longexample: `180`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [dns.answers.type](#field-dns-answers-type)                             | The type of data contained in this resource record.type: keywordexample: `CNAME`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [dns.header_flags](#field-dns-header-flags)                             | Array of 2 letter DNS header flags.Expected values for this field:* `AA`* `TC`* `RD`* `RA`* `AD`* `CD`* `DO`type: keywordNote: This field should contain an array of values.example: `["RD", "RA"]`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [dns.id](#field-dns-id)                                                 | The DNS packet identifier assigned by the program that generated the query. The identifier is copied to the response.type: keywordexample: `62111`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [dns.op_code](#field-dns-op-code)                                       | The DNS operation code that specifies the kind of query in the message. This value is set by the originator of a query and copied into the response.type: keywordexample: `QUERY`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | extended |
| [dns.question.class](#field-dns-question-class)                         | The class of records being queried.type: keywordexample: `IN`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [dns.question.name](#field-dns-question-name)                           | The name being queried.If the name field contains non-printable characters (below 32 or above 126), those characters should be represented as escaped base 10 integers (\DDD). Back slashes and quotes should be escaped. Tabs, carriage returns, and line feeds should be converted to \t, \r, and \n respectively.type: keywordexample: `www.example.com`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [dns.question.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/dns/#dns-question-name)                                                                                                                                                                                                     | extended |
| [dns.question.registered_domain](#field-dns-question-registered-domain) | The highest registered domain, stripped of the subdomain.For example, the registered domain for "foo.example.com" is "example.com".This value can be determined precisely with a list like the public suffix list ([https://publicsuffix.org](https://publicsuffix.org)). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".type: keywordexample: `example.com`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [dns.question.subdomain](#field-dns-question-subdomain)                 | The subdomain is all of the labels under the registered_domain.If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.type: keywordexample: `www`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [dns.question.top_level_domain](#field-dns-question-top-level-domain)   | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".This value can be determined precisely with a list like the public suffix list ([https://publicsuffix.org](https://publicsuffix.org)). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".type: keywordexample: `co.uk`                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [dns.question.type](#field-dns-question-type)                           | The type of record being queried.type: keywordexample: `AAAA`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [dns.resolved_ip](#field-dns-resolved-ip)                               | Array containing all IPs seen in `answers.data`.The `answers` array can be difficult to use, because of the variety of data formats it can contain. Extracting all IP addresses seen in there to `dns.resolved_ip` makes it possible to index them as IP addresses, and makes them easier to visualize and query for.type: ipNote: This field should contain an array of values.example: `["10.10.10.10", "10.10.10.11"]`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | extended |
| [dns.response_code](#field-dns-response-code)                           | The DNS response code.type: keywordexample: `NOERROR`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [dns.type](#field-dns-type)                                             | The type of DNS event captured, query or answer.If your source of DNS events only gives you DNS queries, you should only create dns events of type `dns.type:query`.If your source of DNS events gives you answers as well, you should create one event per query (optionally as soon as the query is seen). And a second event containing all query details as well as an array of answers.type: keywordexample: `answer`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |