﻿---
title: DLL fields
description: These fields contain information about code libraries dynamically loaded into processes. Many operating systems refer to "shared code libraries" with...
url: https://www.elastic.co/docs/reference/ecs/ecs-dll
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# DLL fields
These fields contain information about code libraries dynamically loaded into processes.
Many operating systems refer to "shared code libraries" with different names, but this field set refers to all of the following:
- Dynamic-link library (`.dll`) commonly used on Windows
- Shared Object (`.so`) commonly used on Unix-like operating systems
- Dynamic library (`.dylib`) commonly used on macOS


## DLL field details


| Field                                                     | Description                                                                                                                                             | Level    |
|-----------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [dll.name](#field-dll-name)                               | Name of the library.This generally maps to the name of the file on disk.type: keywordexample: `kernel32.dll`                                            | core     |
| [dll.origin_referrer_url](#field-dll-origin-referrer-url) | _This field is beta and subject to change._ The URL of the webpage that linked to the dll file.type: keywordexample: `http://example.com/article1.html` | extended |
| [dll.origin_url](#field-dll-origin-url)                   | _This field is beta and subject to change._ The URL where the dll file is hosted.type: keywordexample: `http://example.com/files/example.dll`           | extended |
| [dll.path](#field-dll-path)                               | Full file path of the library.type: keywordexample: `C:\Windows\System32\kernel32.dll`                                                                  | extended |


### Field sets that can be nested under DLL


| Location               | Field Set                                                                      | Description                                                     |
|------------------------|--------------------------------------------------------------------------------|-----------------------------------------------------------------|
| `dll.code_signature.*` | [code_signature](https://www.elastic.co/docs/reference/ecs/ecs-code_signature) | These fields contain information about binary code signatures.  |
| `dll.hash.*`           | [hash](https://www.elastic.co/docs/reference/ecs/ecs-hash)                     | Hashes, usually file hashes.                                    |
| `dll.pe.*`             | [pe](https://www.elastic.co/docs/reference/ecs/ecs-pe)                         | These fields contain Windows Portable Executable (PE) metadata. |