﻿---
title: Device fields
description: Fields that describe a device instance and its characteristics. Data collected for applications and processes running on a (mobile) device can be enriched...
url: https://www.elastic.co/docs/reference/ecs/ecs-device
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Device fields
Fields that describe a device instance and its characteristics. Data collected for applications and processes running on a (mobile) device can be enriched with these fields to describe the identity, type and other characteristics of the device.
This field group definition is based on the Device namespace of the OpenTelemetry Semantic Conventions ([https://opentelemetry.io/docs/reference/specification/resource/semantic_conventions/device/](https://opentelemetry.io/docs/reference/specification/resource/semantic_conventions/device/)).
<warning>
  These fields are in beta and are subject to change.
</warning>


## Device field details


| Field                                                     | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Level    |
|-----------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [device.id](#field-device-id)                             | The unique identifier of a device. The identifier must not change across application sessions but stay fixed for an instance of a (mobile) device.On iOS, this value must be equal to the vendor identifier ([https://developer.apple.com/documentation/uikit/uidevice/1620059-identifierforvendor](https://developer.apple.com/documentation/uikit/uidevice/1620059-identifierforvendor)). On Android, this value must be equal to the Firebase Installation ID or a globally unique UUID which is persisted across sessions in your application.For GDPR and data protection law reasons this identifier should not carry information that would allow to identify a user.type: keywordexample: `00000000-54b3-e7c7-0000-000046bffd97`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [device.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/device/#device-id) | extended |
| [device.manufacturer](#field-device-manufacturer)         | The vendor name of the device manufacturer.type: keywordexample: `Samsung`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [device.manufacturer](https://opentelemetry.io/docs/specs/semconv/attributes-registry/device/#device-manufacturer)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [device.model.identifier](#field-device-model-identifier) | The machine readable identifier of the device model.type: keywordexample: `SM-G920F`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [device.model.identifier](https://opentelemetry.io/docs/specs/semconv/attributes-registry/device/#device-model-identifier)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | extended |
| [device.model.name](#field-device-model-name)             | The human readable marketing name of the device model.type: keywordexample: `Samsung Galaxy S6`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [device.model.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/device/#device-model-name)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | extended |
| [device.product.id](#field-device-product-id)             | _This field is beta and subject to change._ A unique identifier assigned by the vendor to distinguish different product models. This is typically a hexadecimal value that, combined with the vendor ID, creates a globally unique device identifier.The product ID is assigned by the device manufacturer and should remain consistent across all instances of the same product model. For hardware devices, this often corresponds to the Product ID (PID) in device descriptors.See [https://learn.microsoft.com/en-us/windows-hardware/drivers/install/standard-usb-identifiers](https://learn.microsoft.com/en-us/windows-hardware/drivers/install/standard-usb-identifiers) for more details on product identification standards.type: keywordexample: `43981`                                                                                                                                                                                                                                                                                                     | extended |
| [device.product.name](#field-device-product-name)         | _This field is beta and subject to change._ The human-readable marketing or commercial name of the device as designated by the manufacturer. This name is typically found in product documentation, marketing materials, or device packaging.Unlike the product.id which is a technical identifier, this field contains the consumer-facing product name that would be recognizable to end users. The name should be exactly as provided by the manufacturer and may include model numbers, series designations, or other identifying information.type: keywordexample: `Extreme V2 SSD`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [device.serial_number](#field-device-serial-number)       | _This field is beta and subject to change._ The unique serial number serves as a distinct identifier for each device, aiding in inventory management and device authentication.type: keywordexample: `DJGAQS4CW5`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | core     |
| [device.type](#field-device-type)                         | _This field is beta and subject to change._ A classification of the device based on its primary function or device class. This field categorizes devices into functional groups to enable policy enforcement and monitoring based on device capabilities.The classification should follow standard device class definitions where possible, such as "Storage Device", "Human Interface Device", "Audio", "Video", "Network", "Communication", etc. This allows for consistent categorization across different device types and manufacturers.See [https://www.usb.org/defined-class-codes](https://www.usb.org/defined-class-codes) for standard device class definitions.type: keywordexample: `Storage Device`                                                                                                                                                                                                                                                                                                                                                         | extended |
| [device.vendor.id](#field-device-vendor-id)               | _This field is beta and subject to change._ A unique identifier assigned to device manufacturers by standards organizations. This is typically a hexadecimal value that uniquely identifies the vendor/manufacturer of the device.The vendor ID is assigned by standards bodies and remains consistent across all products from the same manufacturer. For hardware devices, this often corresponds to the Vendor ID (VID) in device descriptors. This identifier enables tracking and policy enforcement at the manufacturer level.See [https://learn.microsoft.com/en-us/windows-hardware/drivers/install/standard-usb-identifiers](https://learn.microsoft.com/en-us/windows-hardware/drivers/install/standard-usb-identifiers) for more information on vendor identification standards.type: keywordexample: `4660`                                                                                                                                                                                                                                                  | extended |
| [device.vendor.name](#field-device-vendor-name)           | _This field is beta and subject to change._ The name of the organization or company that manufactured or produced the device. This should be the official registered business name or commonly recognized brand name of the manufacturer.The vendor name provides human-readable identification of the device manufacturer and should be consistent with the vendor.id field. This field is useful for reporting, device inventory management, and applying vendor-specific policies or security rules.type: keywordexample: `SanDisk`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |