﻿---
title: Map custom data to ECS
description: A common schema helps you correlate and use data from various sources. Fields for most Elastic modules and solutions (version 7.0 and later) are mapped...
url: https://www.elastic.co/docs/reference/ecs/ecs-converting
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Map custom data to ECS
A common schema helps you correlate and use data from various sources.
Fields for most Elastic modules and solutions (version 7.0 and later) are mapped to the Elastic Common Schema. You may want to map data from other implementations to ECS to help you correlate data across all of your products and solutions.

## Before you start

Before you start a conversion, be sure that you understand the basics below.

### Core and extended levels

Make sure you understand the distinction between Core and Extended fields, as explained in the [Guidelines and Best Practices](https://www.elastic.co/docs/reference/ecs/ecs-guidelines).
Core and Extended fields are documented in the [*ECS Field Reference*](https://www.elastic.co/docs/reference/ecs/ecs-field-reference) or, for a single page representation of all fields, please see the [generated CSV of fields](https://github.com/elastic/ecs/blob/master/generated/csv/fields.csv).

### An approach to mapping an existing implementation

Here’s the recommended approach for converting an existing implementation to ECS.
1. Review each field in your original event and map it to the relevant ECS field.
   - Start by mapping your field to the relevant ECS Core field.
- If a relevant ECS Core field does not exist, map your field to the relevant ECS Extended field.
- If no relevant ECS Extended field exists, consider keeping your field with its original details, or possibly renaming it using ECS naming guidelines and attempt to map one or more of your original event fields to it.
2. Review each ECS Core field, and attempt to populate it.
   - Review your original event data again
- Consider populating the field based on additional meta-data such as static information (e.g. add `event.category:authentication` even if your auth events don’t mention the word "authentication")
- Consider capturing additional environment meta-data, such as information about the host, container or cloud instance.
3. Review other extended fields from any field set you are already using, and attempt to populate it as well.
4. Set `ecs.version` to the version of the schema you are conforming to. This will allow you to upgrade your sources, pipelines and content (like dashboards) smoothly in the future.


### Use a spreadsheet to plan your migration

Using a spreadsheet to plan the migration from pre-existing source fields to ECS is a common practice. It’s a good way to address each of your fields methodically among colleagues.
To help you plan your migration, Elastic offers a [spreadsheet template](https://ela.st/sample-pipeline-mapping). You can use a CSV version of this spreadsheet to [automatically create an Elasticsearch ingest pipeline](#ecs-map-custom-data-to-ecs-es-pipeline). This is the easiest and most consistent way to map your custom data to ECS, regardless of your ingest method.

## Map custom data to ECS using an Elasticsearch ingest pipeline

Use Kibana's **Create pipeline from CSV** feature to create an Elasticsearch ingest pipeline from a CSV file that maps custom data to ECS fields.
Before you start, ensure you meet the [prerequisites](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#ingest-prerequisites) to create ingest pipelines in Kibana.
1. Download or make a copy of the [spreadsheet template](https://ela.st/sample-pipeline-mapping).
2. Use the spreadsheet to map your custom data to ECS fields. While you can include additional columns, Kibana only processes the following supported columns. Other columns are ignored.

<dropdown title="Supported columns">
  <definitions>
    <definition term="source_field">
      (Required) JSON field key from your custom data. Supports dot notation. Rows with an empty `source_field` are skipped.
    </definition>
    <definition term="destination_field">
      (Required) ECS field name. Supports dot notation. To perform a `format_action` without renaming the field, leave `destination_field` empty.
    </definition>
  </definitions>
  If the `destination field` is `@timestamp`, a `format_action` of `parse_timestamp` and a `timestamp_format` of `UNIX_MS` are used, regardless of any provided values. This helps prevent downstream conversion problems.
  <definitions>
    <definition term="format_action">
      (Optional) Conversion to apply to the field value.
    </definition>
  </definitions>

  <dropdown title="Valid values">
    <definitions>
      <definition term="(empty)">
        No conversion.
      </definition>
      <definition term="parse_timestamp">
        Formats a date or time value. To specify a format, use `timestamp_format`.
      </definition>
      <definition term="to_array">
        Converts to an array.
      </definition>
      <definition term="to_boolean">
        Converts to a boolean.
      </definition>
      <definition term="to_float">
        Converts to a floating point number.
      </definition>
      <definition term="to_integer">
        Converts to an integer
      </definition>
      <definition term="to_string">
        Converts to a string.
      </definition>
      <definition term="lowercase">
        Converts to lowercase.
      </definition>
      <definition term="uppercase">
        Converts to uppercase.
      </definition>
    </definitions>
  </dropdown>

  <definitions>
    <definition term="timestamp_format">
      (Optional) Time and date format to use with the `parse_timestamp` format action. Valid values are `UNIX`, `UNIX_MS`, `ISO8601`, `TAI64N`, and [Java time patterns](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-date-format). Defaults to `UNIX_MS`.
    </definition>
    <definition term="copy_action">
      (Optional) Action to take on the `source_field`. Valid values are:
    </definition>
  </definitions>

  <dropdown title="Valid values">
    <definitions>
      <definition term="(empty)">
        (Default) Uses the default action. You’ll specify the default action later on Kibana's **Create pipeline from CSV** page.
      </definition>
      <definition term="copy">
        Makes a copy of the `source_field` to use as the `destination_field`. The final document contains both fields.
      </definition>
      <definition term="rename">
        Renames the `source_field` to the `destination_field`. The final document only contains the `destination_field`.
      </definition>
    </definitions>
  </dropdown>
</dropdown>

1. Save and export your spreadsheet as a CSV file.
   <note>
   Kibana's **Create pipeline from CSV** feature only supports CSV files up to 100 MB.
   </note>
2. In Kibana, open the main menu and click **Stack Management > Ingest Pipelines > Create pipeline > New pipeline from CSV**.
   
   ![Create Pipeline from CSV in Kibana](https://www.elastic.co/docs/reference/ecs/images/kib-create-pipeline-from-csv.png)
3. On the **Create pipeline from CSV** page, upload your CSV file.
4. Under **Default action**, select the **Copy field name** or **Rename field** option.
   For the **Copy field name** option, Kibana makes a copy of the `source_field` to use as the `destination_field` by default. The final document contains both fields.
   For the **Rename field** option, renames the `source_field` to the `destination_field` by default. The final document only contains the `destination_field`.
   You can override this default using the `copy_action` column of your CSV.
5. Click **Process CSV**.
   Kibana displays a JSON preview of the ingest pipeline generated from your CSV file.
   
   ![Preview pipeline from CSV in Kibana](https://www.elastic.co/docs/reference/ecs/images/kib-create-pipeline-from-csv-preview.png)
6. To create the pipeline, click **Continue to create pipeline**.
7. On the **Create pipeline** page, you can add additional ingest processors to your pipeline.
   When you’re done, click **Create pipeline**.