﻿---
title: Container fields
description: Container fields are used for meta information about the specific container that is the source of information. These fields help correlate data based...
url: https://www.elastic.co/docs/reference/ecs/ecs-container
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Container fields
Container fields are used for meta information about the specific container that is the source of information.
These fields help correlate data based containers from any runtime.

## Container field details


| Field                                                                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Level    |
|---------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [container.cpu.usage](#field-container-cpu-usage)                                     | Percent CPU used which is normalized by the number of CPU cores and it ranges from 0 to 1. Scaling factor: 1000.type: scaled_float![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [container.cpu.usage](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.container.cpu.usage+--%3E%22&type=code)                                                                                                                                                                                                                                  | extended |
| [container.disk.read.bytes](#field-container-disk-read-bytes)                         | The total number of bytes (gauge) read successfully (aggregated from all disks) since the last metric collection.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [container.disk.write.bytes](#field-container-disk-write-bytes)                       | The total number of bytes (gauge) written successfully (aggregated from all disks) since the last metric collection.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [container.id](#field-container-id)                                                   | Unique container id.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [container.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-id)                                                                                                                                                                                                                                                                                                                                                                                               | core     |
| [container.image.hash.all](#field-container-image-hash-all)                           | An array of digests of the image the container was built on. Each digest consists of the hash algorithm and value in this format: `algorithm:value`. Algorithm names should align with the field names in the ECS hash field set.type: keywordNote: This field should contain an array of values.example: `[sha256:f8fefc80e3273dc756f288a63945820d6476ad64883892c771b5e2ece6bf1b26]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [container.image.repo_digests](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-image-repo-digests) | extended |
| [container.image.name](#field-container-image-name)                                   | Name of the image the container was built on.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [container.image.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-image-name)                                                                                                                                                                                                                                                                                                                                                      | extended |
| [container.image.tag](#field-container-image-tag)                                     | Container image tags.type: keywordNote: This field should contain an array of values.![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [container.image.tags](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-image-tags)                                                                                                                                                                                                                                                                                                                 | extended |
| [container.labels](#field-container-labels)                                           | Image labels.type: object![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [container.label](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-label)                                                                                                                                                                                                                                                                                                                                                                                             | extended |
| [container.memory.usage](#field-container-memory-usage)                               | Memory usage percentage and it ranges from 0 to 1. Scaling factor: 1000.type: scaled_float![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![metric](https://img.shields.io/badge/metric-cb00cb?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [container.memory.usage](https://github.com/search?q=repo%3Aopen-telemetry%2Fsemantic-conventions+%22%3C%21--+semconv+metric.container.memory.usage+--%3E%22&type=code)                                                                                                                                                                                                                                                                    | extended |
| [container.name](#field-container-name)                                               | Container name.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [container.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-name)                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [container.network.egress.bytes](#field-container-network-egress-bytes)               | The number of bytes (gauge) sent out on all network interfaces by the container since the last metric collection.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [container.network.ingress.bytes](#field-container-network-ingress-bytes)             | The number of bytes received (gauge) on all network interfaces by the container since the last metric collection.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [container.runtime](#field-container-runtime)                                         | Runtime managing this container.type: keywordexample: `docker`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [container.runtime.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-runtime-name)                                                                                                                                                                                                                                                                                                                                    | extended |
| [container.security_context.privileged](#field-container-security-context-privileged) | Indicates whether the container is running in privileged mode.type: boolean                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |