﻿---
title: Code Signature fields
description: These fields contain information about binary code signatures. The code_signature fields are expected to be nested at: dll.code_signature, file.code_signature,...
url: https://www.elastic.co/docs/reference/ecs/ecs-code_signature
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Code Signature fields
These fields contain information about binary code signatures.

## Code Signature field details


| Field                                                                       | Description                                                                                                                                                                                                                                                                 | Level    |
|-----------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [code_signature.digest_algorithm](#field-code-signature-digest-algorithm)   | The hashing algorithm used to sign the process.This value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.type: keywordexample: `sha256`                                                           | extended |
| [code_signature.exists](#field-code-signature-exists)                       | Boolean to capture if a signature is present.type: booleanexample: `true`                                                                                                                                                                                                   | core     |
| [code_signature.flags](#field-code-signature-flags)                         | _This field is beta and subject to change._ The flags used to sign the process.type: keywordexample: `570522385`                                                                                                                                                            | extended |
| [code_signature.signing_id](#field-code-signature-signing-id)               | The identifier used to sign the process.This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.type: keywordexample: `com.apple.xpc.proxy`                                                                     | extended |
| [code_signature.status](#field-code-signature-status)                       | Additional information about the certificate status.This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.type: keywordexample: `ERROR_UNTRUSTED_ROOT` | extended |
| [code_signature.subject_name](#field-code-signature-subject-name)           | Subject name of the code signertype: keywordexample: `Microsoft Corporation`                                                                                                                                                                                                | core     |
| [code_signature.team_id](#field-code-signature-team-id)                     | The team identifier used to sign the process.This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.type: keywordexample: `EQHXZ8M8AV`                                                                                  | extended |
| [code_signature.thumbprint_sha256](#field-code-signature-thumbprint-sha256) | _This field is beta and subject to change._ Certificate SHA256 hash that uniquely identifies the code signer.type: keywordexample: `c0f23a8eb1cba0ccaa88483b5a234c96e4bdfec719bf458024e68c2a8183476b`                                                                       | extended |
| [code_signature.timestamp](#field-code-signature-timestamp)                 | Date and time when the code signature was generated and signed.type: dateexample: `2021-01-01T12:10:30Z`                                                                                                                                                                    | extended |
| [code_signature.trusted](#field-code-signature-trusted)                     | Stores the trust status of the certificate chain.Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.type: booleanexample: `true`                                             | extended |
| [code_signature.valid](#field-code-signature-valid)                         | Boolean to capture if the digital signature is verified against the binary content.Leave unpopulated if a certificate was unchecked.type: booleanexample: `true`                                                                                                            | extended |


## Field reuse

The `code_signature` fields are expected to be nested at:
- `dll.code_signature`
- `file.code_signature`
- `process.code_signature`

Note also that the `code_signature` fields are not expected to be used directly at the root of the events.