﻿---
title: Cloud fields
description: Fields related to the cloud or infrastructure the events are coming from. The cloud fields are expected to be nested at: cloud.origin, cloud.target. Note...
url: https://www.elastic.co/docs/reference/ecs/ecs-cloud
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Cloud fields
Fields related to the cloud or infrastructure the events are coming from.

## Cloud field details


| Field                                                     | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | Level    |
|-----------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [cloud.account.id](#field-cloud-account-id)               | The cloud account or organization id used to identify different entities in a multi-tenant environment.Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.type: keywordexample: `666777888999`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [cloud.account.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/#cloud-account-id)                                                               | extended |
| [cloud.account.name](#field-cloud-account-name)           | The cloud account name or alias used to identify different entities in a multi-tenant environment.Examples: AWS account name, Google Cloud ORG display name.type: keywordexample: `elastic-dev`                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [cloud.availability_zone](#field-cloud-availability-zone) | Availability zone in which this host, resource, or service is located.type: keywordexample: `us-east-1c`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [cloud.availability_zone](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/#cloud-availability-zone)                                                                                                                                                              | extended |
| [cloud.instance.id](#field-cloud-instance-id)             | Instance ID of the host machine.type: keywordexample: `i-1234567890abcdef0`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | extended |
| [cloud.instance.name](#field-cloud-instance-name)         | Instance name of the host machine.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [cloud.machine.type](#field-cloud-machine-type)           | Machine type of the host machine.type: keywordexample: `t2.medium`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [cloud.project.id](#field-cloud-project-id)               | The cloud project identifier.Examples: Google Cloud Project id, Azure Project id.type: keywordexample: `my-project`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [cloud.project.name](#field-cloud-project-name)           | The cloud project name.Examples: Google Cloud Project name, Azure Project name.type: keywordexample: `my project`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [cloud.provider](#field-cloud-provider)                   | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.type: keywordexample: `aws`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [cloud.provider](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/#cloud-provider)                                                                                                                                                                             | extended |
| [cloud.region](#field-cloud-region)                       | Region in which this host, resource, or service is located.type: keywordexample: `us-east-1`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [cloud.region](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/#cloud-region)                                                                                                                                                                                                | extended |
| [cloud.service.name](#field-cloud-service-name)           | The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server.Examples: app engine, app service, cloud run, fargate, lambda.type: keywordexample: `lambda`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![equivalent](https://img.shields.io/badge/equivalent-1ba9f5?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [cloud.platform](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/#cloud-platform) | extended |


## Field reuse

The `cloud` fields are expected to be nested at:
- `cloud.origin`
- `cloud.target`

Note also that the `cloud` fields may be used directly at the root of the events.

### Field sets that can be nested under Cloud


| Location         | Field Set                                                      | Description                                                                                  |
|------------------|----------------------------------------------------------------|----------------------------------------------------------------------------------------------|
| `cloud.entity.*` | [entity](https://www.elastic.co/docs/reference/ecs/ecs-entity) | Fields to describe various types of entities across IT environments.                         |
| `cloud.origin.*` | [cloud](https://www.elastic.co/docs/reference/ecs/ecs-cloud)   | Provides the cloud information of the origin entity in case of an incoming request or event. |
| `cloud.target.*` | [cloud](https://www.elastic.co/docs/reference/ecs/ecs-cloud)   | Provides the cloud information of the target entity in case of an outgoing request or event. |


### Cloud field usage

For usage and examples of the cloud fields, please see the [Cloud fields usage and examples](https://www.elastic.co/docs/reference/ecs/ecs-cloud-usage) section.