﻿---
title: Cloud fields usage and examples
description: Here are the subjects covered in this page. Field reuse. The cloud fields can be used to * describe the cloud resource an event comes from * or to describe...
url: https://www.elastic.co/docs/reference/ecs/ecs-cloud-usage
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Cloud fields usage and examples
Here are the subjects covered in this page.
- [Field reuse](#ecs-cloud-usage-field-reuse)
  - [Cloud fields at the root of an event](#ecs-cloud-usage-cloud-at-root)
- [Describing external cloud resources in an invocation relationship](#ecs-cloud-usage-origin-target)


## Field reuse

The cloud fields can be used to * [describe the cloud resource an event comes from](#ecs-cloud-usage-cloud-at-root) * or to [describe the context of an external cloud resource](#ecs-cloud-usage-origin-target) that has a direct invocation relationship to the observed service or resource

### Cloud fields at the root of an event

Use the cloud fields at the root of an event to describe the cloud resource the event primarily relates to. An example for this use case is a log entry being recorded for a service that is deployed in a cloud environment:
```json
{
  "cloud": {
    "provider": "aws",
    "region": "us-east-1",
    "service": { "name": "ec2" }
  }
}
```


### Describing external cloud resources in an invocation relationship

Managed cloud services can be in an invocation relationship to the observed service (i.e. service for which the corresponding event is captured). For instance, an observed service running on AWS Lambda can be invoked through an AWS API Gateway. Another example is an observed service that invokes an external cloud service (e.g. AWS Simple Email Service). In the context of an invocation relationship, cloud fields can be nested under `cloud.origin.*` and `cloud.target.*`, respectively, to capture the cloud context on origin or target cloud services from the perspective of an observed service. This concept is similar to [nesting of service fields](/docs/reference/ecs/ecs-service-usage#ecs-service-usage-origin-target) under `service.origin.*` and `service.target.*`.
Let’s consider an exemplary event that represents an inbound AWS Lambda invocation coming from an AWS API Gateway. Use the following `cloud.origin.*` nesting to describe the API Gateway service from the perspective of the AWS Lambda service:
```json
{
  "service": { 
    "name": "MyLambdaFunction",
    "version": "1.0.0",
    "origin": { 
      "name": "MyGateway",
      "version" "2.0",
    }
  },
  "cloud": { 
    "provider": "aws",
    "region": "us-east-1",
    "service": { "name": "lambda" },
    "origin": { 
      "provider": "aws",
      "region": "eu-west-1",
      "service": { "name": "apigateway" }
    }
  }
}
```

Note that `cloud.origin.*` and `cloud.target.*` fields should only be used on events that represent an invocation relationship.