﻿---
title: Client fields
description: A client is defined as the initiator of a network connection for events regarding sessions, connections, or bidirectional flow records. For TCP events,...
url: https://www.elastic.co/docs/reference/ecs/ecs-client
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Client fields
A client is defined as the initiator of a network connection for events regarding sessions, connections, or bidirectional flow records.
For TCP events, the client is the initiator of the TCP connection that sends the SYN packet(s). For other protocols, the client is generally the initiator or requestor in the network transaction. Some systems use the term "originator" to refer the client in TCP connections. The client fields describe details about the system acting as the client in the network event. Client fields are usually populated in conjunction with server fields. Client fields are generally not populated for packet-level events.
Client / server representations can add semantic context to an exchange, which is helpful to visualize the data in certain situations. If your context falls in that category, you should still ensure that source and destination are filled appropriately.

## Client field details


| Field                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Level    |
|-------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [client.address](#field-client-address)                     | Some event client addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field.Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [client.address](https://opentelemetry.io/docs/specs/semconv/attributes-registry/client/#client-address) | extended |
| [client.bytes](#field-client-bytes)                         | Bytes sent from the client to the server.type: longexample: `184`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | core     |
| [client.domain](#field-client-domain)                       | The domain name of the client system.This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.type: keywordexample: `foo.example.com`                                                                                                                                                                                                                                                                                                                                                                             | core     |
| [client.ip](#field-client-ip)                               | IP address of the client (IPv4 or IPv6).type: ip                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | core     |
| [client.mac](#field-client-mac)                             | MAC address of the client.The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.type: keywordexample: `00-00-5E-00-53-23`                                                                                                                                                                                                                                                                                                                    | core     |
| [client.nat.ip](#field-client-nat-ip)                       | Translated IP of source based NAT sessions (e.g. internal client to internet).Typically connections traversing load balancers, firewalls, or routers.type: ip                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [client.nat.port](#field-client-nat-port)                   | Translated port of source based NAT sessions (e.g. internal client to internet).Typically connections traversing load balancers, firewalls, or routers.type: long                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [client.packets](#field-client-packets)                     | Packets sent from the client to the server.type: longexample: `12`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | core     |
| [client.port](#field-client-port)                           | Port of the client.type: long![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [client.port](https://opentelemetry.io/docs/specs/semconv/attributes-registry/client/#client-port)                                                                                                                                                                                                                                                              | core     |
| [client.registered_domain](#field-client-registered-domain) | The highest registered client domain, stripped of the subdomain.For example, the registered domain for "foo.example.com" is "example.com".This value can be determined precisely with a list like the public suffix list ([https://publicsuffix.org](https://publicsuffix.org)). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".type: keywordexample: `example.com`                                                                                                                                                                                               | extended |
| [client.subdomain](#field-client-subdomain)                 | The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.For example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.type: keywordexample: `east`                                                  | extended |
| [client.top_level_domain](#field-client-top-level-domain)   | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".This value can be determined precisely with a list like the public suffix list ([https://publicsuffix.org](https://publicsuffix.org)). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".type: keywordexample: `co.uk`                                                                                                                                                                  | extended |


### Field sets that can be nested under Client


| Location        | Field Set                                                  | Description                                                       |
|-----------------|------------------------------------------------------------|-------------------------------------------------------------------|
| `client.as.*`   | [as](https://www.elastic.co/docs/reference/ecs/ecs-as)     | Fields describing an Autonomous System (Internet routing prefix). |
| `client.geo.*`  | [geo](https://www.elastic.co/docs/reference/ecs/ecs-geo)   | Fields describing a location.                                     |
| `client.user.*` | [user](https://www.elastic.co/docs/reference/ecs/ecs-user) | Fields to describe the user relevant to the event.                |