﻿---
title: ECS categorization fields
description: At a high level, ECS provides fields to classify events in two different ways: "Where it’s from" (e.g., event.module, event.dataset, agent.type, observer.type,...
url: https://www.elastic.co/docs/reference/ecs/ecs-category-field-values-reference
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ECS categorization fields
At a high level, ECS provides fields to classify events in two different ways: "Where it’s from" (e.g., `event.module`, `event.dataset`, `agent.type`, `observer.type`, etc.), and "What it is." The categorization fields hold the "What it is" information, independent of the source of the events.
ECS defines four categorization fields for this purpose, each of which falls under the `event.*` field set.

## Categorization fields

- [event.kind](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-kind)
- [event.category](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-category)
- [event.type](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-type)
- [event.outcome](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-outcome)

<note>
  If your events don’t match any of these categorization values, you should leave the fields empty. This will ensure you can start populating the fields once the appropriate categorization values are published, in a later release.
</note>


## Categorization usage

[Using the categorization fields](https://www.elastic.co/docs/reference/ecs/ecs-using-categorization-fields) contains examples combining the categorization fields to classify different types of events.