﻿---
title: Base fields
description: The base field set contains all fields which are at the root of the events. These fields are common across all types of events. 
url: https://www.elastic.co/docs/reference/ecs/ecs-base
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Base fields
The `base` field set contains all fields which are at the root of the events. These fields are common across all types of events.

## Base field details


| Field                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | Level |
|--------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------|
| [@timestamp](#field-timestamp) | Date/time when the event originated.This is the date/time extracted from the event, typically representing when the event was generated by the source.If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline.Required field for all events.type: dateexample: `2016-05-23T08:05:34.853Z`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [time_unix_nano](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+time_unix_nano+%22&type=code)![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [observed_time_unix_nano](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+observed_time_unix_nano+%22&type=code)![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [start_time_unix_nano](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+start_time_unix_nano+%22&type=code)**Note:** On logs, events and metrics, `time_unix_nano` defines the time of the event. For logs, `observed_time_unix_nano` defines the time when the event was observed by the collection system. On spans, `start_time_unix_nano` represents the start time of the span. | core  |
| [labels](#field-labels)        | Custom key/value pairs.Can be used to add meta information to events. Should not contain nested objects. All values are stored as keyword.Example: `docker` and `k8s` labels.type: objectexample: `{"application": "foo-bar", "env": "production"}`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [k8s.pod.label](https://opentelemetry.io/docs/specs/semconv/attributes-registry/k8s/#k8s-pod-label)![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![related](https://img.shields.io/badge/related-efc20d?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [container.label](https://opentelemetry.io/docs/specs/semconv/attributes-registry/container/#container-label)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | core  |
| [message](#field-message)      | For log events the message field contains the log message, optimized for viewing in a log viewer.For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event.If multiple messages exist, they can be combined into one message.type: match_only_textexample: `Hello World`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![otlp](https://img.shields.io/badge/OTLP-ffdcb2?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [body](https://github.com/search?q=repo%3Aopen-telemetry%2Fopentelemetry-proto+%22+body+%22&type=code)**Note:** The `body` in OTLP is of type `Any` and can be either an unstructured log message or a structured event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | core  |
| [tags](#field-tags)            | List of keywords used to tag each event.type: keywordNote: This field should contain an array of values.example: `["production", "env2"]`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | core  |