﻿---
title: Autonomous System fields
description: An autonomous system (AS) is a collection of connected Internet Protocol (IP) routing prefixes under the control of one or more network operators on behalf...
url: https://www.elastic.co/docs/reference/ecs/ecs-as
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Autonomous System fields
An autonomous system (AS) is a collection of connected Internet Protocol (IP) routing prefixes under the control of one or more network operators on behalf of a single administrative entity or domain that presents a common, clearly defined routing policy to the internet.

## Autonomous System field details


| Field                                               | Description                                                                                                                                                      | Level    |
|-----------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [as.number](#field-as-number)                       | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.type: longexample: `15169` | extended |
| [as.organization.name](#field-as-organization-name) | Organization name.type: keywordMulti-fields:* as.organization.name.text (type: match_only_text)example: `Google LLC`                                             | extended |


## Field reuse

The `as` fields are expected to be nested at:
- `client.as`
- `destination.as`
- `server.as`
- `source.as`
- `threat.enrichments.indicator.as`
- `threat.indicator.as`

Note also that the `as` fields are not expected to be used directly at the root of the events.